/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.VectorIO;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class SemanticSpaceWriter {
    private final File outputFile;
    private final SemanticSpaceIO.SSpaceFormat format;
    private final DataOutputStream writer;
    private int vectorsSeen;
    private int vectorLength;

    public SemanticSpaceWriter(File file, SemanticSpaceIO.SSpaceFormat sSpaceFormat) {
        this.outputFile = file;
        this.format = sSpaceFormat;
        try {
            this.writer = new DataOutputStream(new FileOutputStream(file));
            this.writeEmptyHeader();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public void close() throws IOException {
        this.writer.close();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.outputFile, "rw");
        randomAccessFile.seek(4L);
        switch (this.format) {
            case TEXT: 
            case SPARSE_TEXT: {
                randomAccessFile.writeChars(this.vectorsSeen + " " + this.vectorLength);
                break;
            }
            case BINARY: 
            case SPARSE_BINARY: {
                randomAccessFile.writeInt(this.vectorsSeen);
                randomAccessFile.writeInt(this.vectorLength);
                break;
            }
            default: {
                assert (false) : "unhandled s-space format";
                break;
            }
        }
        randomAccessFile.close();
    }

    public File getFile() {
        return this.outputFile;
    }

    public void write(String string, Vector vector) throws IOException {
        this.vectorLength = vector.length();
        ++this.vectorsSeen;
        switch (this.format) {
            case SPARSE_TEXT: {
                PrintWriter printWriter = new PrintWriter(this.writer);
                printWriter.print(string + "|");
                StringBuilder stringBuilder = null;
                if (vector instanceof SparseVector) {
                    if (vector instanceof DoubleVector) {
                        SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)vector;
                        int[] nArray = sparseDoubleVector.getNonZeroIndices();
                        stringBuilder = new StringBuilder(nArray.length * 4);
                        stringBuilder.append(0).append(",").append(sparseDoubleVector.get(0));
                        for (int i = 1; i < nArray.length; ++i) {
                            stringBuilder.append(",").append(i).append(",").append(sparseDoubleVector.get(i));
                        }
                    } else {
                        SparseVector sparseVector = (SparseVector)vector;
                        int[] nArray = sparseVector.getNonZeroIndices();
                        stringBuilder = new StringBuilder(nArray.length * 4);
                        stringBuilder.append(0).append(",").append(sparseVector.getValue(0).doubleValue());
                        for (int i = 1; i < nArray.length; ++i) {
                            stringBuilder.append(",").append(i).append(",").append(sparseVector.getValue(i).doubleValue());
                        }
                    }
                } else {
                    boolean bl = true;
                    stringBuilder = new StringBuilder(this.vectorLength / 2);
                    for (int i = 0; i < vector.length(); ++i) {
                        double d = vector.getValue(i).doubleValue();
                        if (d == 0.0) continue;
                        if (bl) {
                            stringBuilder.append(i).append(",").append(d);
                            bl = false;
                            continue;
                        }
                        stringBuilder.append(",").append(i).append(",").append(d);
                    }
                }
                printWriter.println(stringBuilder.toString());
                break;
            }
            case TEXT: {
                PrintWriter printWriter = new PrintWriter(this.writer);
                printWriter.println(string + "|" + VectorIO.toString(vector));
                break;
            }
            case BINARY: {
                this.writer.writeUTF(string);
                for (int i = 0; i < vector.length(); ++i) {
                    this.writer.writeDouble(vector.getValue(i).doubleValue());
                }
                break;
            }
            case SPARSE_BINARY: {
                this.writer.writeUTF(string);
                if (vector instanceof SparseVector) {
                    if (vector instanceof DoubleVector) {
                        SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)vector;
                        int[] nArray = sparseDoubleVector.getNonZeroIndices();
                        this.writer.writeInt(nArray.length);
                        for (int n : nArray) {
                            this.writer.writeInt(n);
                            this.writer.writeDouble(sparseDoubleVector.get(n));
                        }
                    } else {
                        SparseVector sparseVector = (SparseVector)vector;
                        int[] nArray = sparseVector.getNonZeroIndices();
                        this.writer.writeInt(nArray.length);
                        for (int n : nArray) {
                            this.writer.writeInt(n);
                            this.writer.writeDouble(sparseVector.getValue(n).doubleValue());
                        }
                    }
                } else {
                    int n;
                    int n2 = 0;
                    for (n = 0; n < vector.length(); ++n) {
                        if (vector.getValue(n).doubleValue() == 0.0) continue;
                        ++n2;
                    }
                    this.writer.writeInt(n2);
                    for (n = 0; n < vector.length(); ++n) {
                        double d = vector.getValue(n).doubleValue();
                        if (d == 0.0) continue;
                        this.writer.writeInt(n);
                        this.writer.writeDouble(d);
                    }
                }
                break;
            }
        }
    }

    private void writeEmptyHeader() throws IOException {
        SemanticSpaceIO.writeHeader(this.writer, this.format);
        switch (this.format) {
            case TEXT: 
            case SPARSE_TEXT: {
                char[] cArray = new char[128];
                Arrays.fill(cArray, ' ');
                String string = new String(cArray);
                PrintWriter printWriter = new PrintWriter(this.writer);
                printWriter.println(string);
                break;
            }
            case BINARY: 
            case SPARSE_BINARY: {
                this.writer.writeInt(0);
                this.writer.writeInt(0);
                break;
            }
            default: {
                assert (false) : "unhandled s-space format";
                break;
            }
        }
    }
}

