/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering.seeding;

import edu.ucla.sspace.clustering.seeding.KMeansSeed;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.ScaledDoubleVector;
import edu.ucla.sspace.vector.VectorMath;

public class OrssSeed
implements KMeansSeed {
    private static final double EPSILON = 0.001;

    @Override
    public DoubleVector[] chooseSeeds(int n, Matrix matrix) {
        int n2;
        int n3 = matrix.rows();
        DoubleVector[] doubleVectorArray = new DoubleVector[n];
        DoubleVector doubleVector = new DenseVector(matrix.columns());
        for (int i = 0; i < n3; ++i) {
            VectorMath.add(doubleVector, matrix.getRowVector(i));
        }
        doubleVector = new ScaledDoubleVector(doubleVector, 1.0 / (double)n3);
        double d = 0.0;
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = Similarity.euclideanDistance(doubleVector, matrix.getRowVector(i));
            d += dArray[i];
        }
        double d2 = Math.random();
        double d3 = 0.0;
        for (int i = 0; i < n3; ++i) {
            double d4 = dArray[i];
            double d5 = d + (double)n3 * d4 * d4;
            if (!((d2 -= (d5 /= (double)(2 * n3) * d)) <= 0.001)) continue;
            doubleVectorArray[0] = matrix.getRowVector(i);
            d3 = d4;
            break;
        }
        d2 = Math.random();
        double d6 = d + (double)n3 * Math.pow(d3, 2.0);
        double[] dArray2 = new double[n3];
        boolean bl = false;
        for (n2 = 0; n2 < n3; ++n2) {
            double d7;
            dArray2[n2] = d7 = Similarity.euclideanDistance(doubleVectorArray[0], matrix.getRowVector(n2));
            double d8 = Math.pow(d7, 2.0) / d6;
            if (!((d2 -= d8) <= 0.001) || bl) continue;
            doubleVectorArray[1] = matrix.getRowVector(n2);
            bl = true;
        }
        for (n2 = 2; n2 < n; ++n2) {
            bl = false;
            d2 = Math.random();
            for (int i = 0; i < n3; ++i) {
                double d9;
                double d10 = Similarity.euclideanDistance(doubleVectorArray[n2 - 1], matrix.getRowVector(i));
                if (d10 < dArray2[n2]) {
                    dArray2[i] = d10;
                }
                if (!((d2 -= (d9 = Math.pow(dArray2[i], 2.0))) <= 0.001) || bl) continue;
                doubleVectorArray[n2] = matrix.getRowVector(i);
                bl = true;
            }
        }
        return doubleVectorArray;
    }
}

