/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering.seeding;

import edu.ucla.sspace.clustering.seeding.KMeansSeed;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DoubleVector;

public class KMeansPlusPlusSeed
implements KMeansSeed {
    private static final double EPSILON = 0.001;

    @Override
    public DoubleVector[] chooseSeeds(int n, Matrix matrix) {
        int[] nArray = new int[n];
        DoubleVector[] doubleVectorArray = new DoubleVector[n];
        int n2 = (int)Math.round(Math.random() * (double)(matrix.rows() - 1));
        doubleVectorArray[0] = matrix.getRowVector(n2);
        double[] dArray = new double[matrix.rows()];
        KMeansPlusPlusSeed.computeDistances(dArray, false, matrix, doubleVectorArray[0]);
        for (int i = 1; i < n; ++i) {
            double d = KMeansPlusPlusSeed.distanceSum(dArray);
            double d2 = Math.random();
            n2 = KMeansPlusPlusSeed.chooseWithProbability(dArray, d, d2);
            doubleVectorArray[i] = matrix.getRowVector(n2);
            KMeansPlusPlusSeed.computeDistances(dArray, true, matrix, doubleVectorArray[i]);
        }
        return doubleVectorArray;
    }

    private static double distanceSum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += Math.pow(d2, 2.0);
        }
        return d;
    }

    private static void computeDistances(double[] dArray, boolean bl, Matrix matrix, DoubleVector doubleVector) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = Similarity.euclideanDistance(doubleVector, matrix.getRowVector(i));
            if (bl && (!bl || !(d < dArray[i]))) continue;
            dArray[i] = d;
        }
    }

    private static int chooseWithProbability(double[] dArray, double d, double d2) {
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = Math.pow(dArray[i], 2.0) / d;
            if (!((d2 -= d3) <= 0.001)) continue;
            return i;
        }
        return dArray.length - 1;
    }
}

