/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering.criterion;

import edu.ucla.sspace.clustering.criterion.BaseFunction;
import edu.ucla.sspace.clustering.criterion.CriterionFunction;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DenseDynamicMagnitudeVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import java.util.ArrayList;
import java.util.List;

public abstract class HybridBaseFunction
implements CriterionFunction {
    protected List<DoubleVector> matrix;
    protected int[] assignments;
    protected DoubleVector[] centroids;
    protected int[] clusterSizes;
    protected double[] e1Costs;
    private double e1Cost;
    protected double[] i1Costs;
    private double i1Cost;
    private double totalCost;
    protected DoubleVector completeCentroid;
    protected double[] simToComplete;
    private BaseFunction i1Func;
    private BaseFunction e1Func;

    @Override
    public void setup(Matrix matrix, int[] nArray, int n) {
        int n2;
        this.assignments = nArray;
        this.matrix = new ArrayList<DoubleVector>(matrix.rows());
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            this.matrix.add(matrix.getRowVector(n2));
        }
        this.centroids = new DoubleVector[n];
        this.clusterSizes = new int[n];
        this.simToComplete = new double[n];
        this.e1Costs = new double[n];
        this.i1Costs = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.centroids[n2] = new DenseDynamicMagnitudeVector(matrix.columns());
        }
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            int n3 = nArray[n2];
            VectorMath.add(this.centroids[n3], this.matrix.get(n2));
            int n4 = n3;
            this.clusterSizes[n4] = this.clusterSizes[n4] + 1;
        }
        this.completeCentroid = new DenseDynamicMagnitudeVector(matrix.columns());
        for (DoubleVector doubleVector : this.matrix) {
            VectorMath.add(this.completeCentroid, doubleVector);
        }
        for (int i = 0; i < this.centroids.length; ++i) {
            this.simToComplete[i] = Similarity.cosineSimilarity(this.centroids[i], this.completeCentroid);
        }
        this.i1Func = this.getInternalFunction();
        this.e1Func = this.getExternalFunction();
        CompactSparseVector compactSparseVector = new CompactSparseVector(matrix.columns());
        for (int i = 0; i < n; ++i) {
            if (this.clusterSizes[i] == 0) continue;
            this.i1Costs[i] = this.i1Func.getOldCentroidScore(compactSparseVector, i, this.clusterSizes[i]);
            this.i1Cost += this.i1Costs[i];
            this.e1Costs[i] = this.e1Func.getOldCentroidScore(compactSparseVector, i, this.clusterSizes[i]);
            this.e1Cost += this.e1Costs[i];
        }
        this.totalCost = this.i1Cost / this.e1Cost;
    }

    @Override
    public boolean update(int n) {
        int n2 = this.assignments[n];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.totalCost;
        int n3 = -1;
        DoubleVector doubleVector = this.matrix.get(n);
        double d4 = 0.0;
        double d5 = 0.0;
        if (this.clusterSizes[n2] > 1) {
            d4 = this.e1Func.getOldCentroidScore(doubleVector, n2, this.clusterSizes[n2] - 1);
            d4 -= this.e1Costs[n2];
            d5 = this.i1Func.getOldCentroidScore(doubleVector, n2, this.clusterSizes[n2] - 1);
            d5 -= this.i1Costs[n2];
        }
        for (int i = 0; i < this.centroids.length; ++i) {
            if (n2 == i) continue;
            double d6 = this.e1Func.getNewCentroidScore(i, doubleVector);
            d6 -= this.e1Costs[i];
            double d7 = this.i1Func.getNewCentroidScore(i, doubleVector);
            double d8 = this.i1Cost + (d7 -= this.i1Costs[i]) + d5;
            double d9 = this.e1Cost + d6 + d4;
            double d10 = d8 / d9;
            if (!(d10 > d3)) continue;
            d3 = d10;
            d = d6;
            d2 = d7;
            n3 = i;
        }
        if (n3 >= 0) {
            int n4 = n2;
            this.e1Costs[n4] = this.e1Costs[n4] + d4;
            int n5 = n2;
            this.i1Costs[n5] = this.i1Costs[n5] + d5;
            int n6 = n3;
            this.e1Costs[n6] = this.e1Costs[n6] + d;
            int n7 = n3;
            this.i1Costs[n7] = this.i1Costs[n7] + d2;
            this.e1Func.updateScores(n3, n2, doubleVector);
            this.i1Func.updateScores(n3, n2, doubleVector);
            this.e1Cost += d4 + d;
            this.i1Cost += d5 + d2;
            this.totalCost = this.i1Cost / this.e1Cost;
            int n8 = n2;
            this.clusterSizes[n8] = this.clusterSizes[n8] - 1;
            int n9 = n3;
            this.clusterSizes[n9] = this.clusterSizes[n9] + 1;
            this.centroids[n2] = BaseFunction.subtract(this.centroids[n2], doubleVector);
            this.centroids[n3] = VectorMath.add(this.centroids[n3], doubleVector);
            this.assignments[n] = n3;
            return true;
        }
        return false;
    }

    @Override
    public int[] assignments() {
        return this.assignments;
    }

    @Override
    public DoubleVector[] centroids() {
        return this.centroids;
    }

    @Override
    public int[] clusterSizes() {
        return this.clusterSizes;
    }

    @Override
    public double score() {
        return this.totalCost;
    }

    protected abstract BaseFunction getInternalFunction();

    protected abstract BaseFunction getExternalFunction();
}

