/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.CentroidCluster;
import edu.ucla.sspace.clustering.Cluster;
import edu.ucla.sspace.clustering.OnlineClustering;
import edu.ucla.sspace.clustering.SynchronizedCluster;
import edu.ucla.sspace.util.Generator;
import edu.ucla.sspace.util.Properties;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.Vectors;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class OnlineKMeans<T extends DoubleVector>
implements Generator<OnlineClustering<T>> {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.cluster.OnlineKMeans";
    public static final String MERGE_THRESHOLD_PROPERTY = "edu.ucla.sspace.cluster.OnlineKMeans.merge";
    public static final double DEFAULT_MERGE_THRESHOLD = 0.35;
    public static final int DEFAULT_MAX_CLUSTERS = 15;
    private final double clusterThreshold;
    private final int maxNumClusters;

    public OnlineKMeans() {
        this(new Properties());
    }

    public OnlineKMeans(Properties properties) {
        this.clusterThreshold = properties.getProperty(MERGE_THRESHOLD_PROPERTY, 0.35);
        this.maxNumClusters = properties.getProperty("edu.ucla.sspace.clustering.OnlineClustering.numClusters", 15);
    }

    @Override
    public OnlineClustering<T> generate() {
        return new OnlineKMeansClustering(this.clusterThreshold, this.maxNumClusters);
    }

    public String toString() {
        return "OnLineKMeans_" + this.maxNumClusters + "c_";
    }

    public class OnlineKMeansClustering<T extends DoubleVector>
    implements OnlineClustering<T> {
        private final double clusterThreshold;
        private final int maxNumClusters;
        private final List<Cluster<T>> elements = new CopyOnWriteArrayList<Cluster<T>>();
        private final AtomicInteger idCounter = new AtomicInteger(0);

        public OnlineKMeansClustering(double d, int n) {
            this.clusterThreshold = d;
            this.maxNumClusters = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addVector(T t) {
            Cluster<T> cluster;
            int n = this.idCounter.getAndAdd(1);
            Iterator<Cluster<T>> iterator = this.elements.iterator();
            Cluster<T> cluster2 = null;
            int n2 = this.elements.size();
            double d = -1.0;
            double d2 = -1.0;
            int n3 = 0;
            while (iterator.hasNext()) {
                cluster = iterator.next();
                d2 = cluster.compareWithVector(t);
                if (d2 >= d) {
                    d = d2;
                    cluster2 = cluster;
                    n2 = n3;
                }
                ++n3;
            }
            if (d >= this.clusterThreshold || this.elements.size() >= this.maxNumClusters) {
                cluster2.addVector(t, n);
            } else {
                cluster = this.elements;
                synchronized (cluster) {
                    if (this.elements.size() < this.maxNumClusters) {
                        cluster2 = new SynchronizedCluster<DoubleVector>(new CentroidCluster<DoubleVector>((DoubleVector)Vectors.instanceOf(t)));
                        this.elements.add(cluster2);
                    }
                    if (cluster2 != null) {
                        cluster2.addVector(t, n);
                    }
                }
            }
            return n;
        }

        @Override
        public Cluster<T> getCluster(int n) {
            if (this.elements.size() <= n) {
                return null;
            }
            return this.elements.get(n);
        }

        @Override
        public List<Cluster<T>> getClusters() {
            return this.elements;
        }

        @Override
        public synchronized int size() {
            return this.elements.size();
        }

        public String toString() {
            return "OnlineKMeansClustering-maxNumClusters" + this.maxNumClusters + "-threshold" + this.clusterThreshold;
        }
    }
}

