/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignment;
import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.clustering.HardAssignment;
import edu.ucla.sspace.clustering.criterion.CriterionFunction;
import edu.ucla.sspace.clustering.criterion.I1Function;
import edu.ucla.sspace.clustering.seeding.KMeansSeed;
import edu.ucla.sspace.clustering.seeding.RandomSeed;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.util.LoggerUtil;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.vector.DoubleVector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;

public class DirectClustering
implements Clustering {
    private static final Logger LOGGER = Logger.getLogger(DirectClustering.class.getName());
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.clustering.DirectClustering";
    public static final String CRITERIA_PROPERTY = "edu.ucla.sspace.clustering.DirectClustering.criteria";
    public static final String REPEAT_PROPERTY = "edu.ucla.sspace.clustering.DirectClustering.repeat";
    public static final String SEED_PROPERTY = "edu.ucla.sspace.clustering.DirectClustering.seed";
    private static final String DEFAULT_SEED = "edu.ucla.sspace.clustering.seeding.RandomSeed";
    private static final String DEFAULT_CRITERION = "edu.ucla.sspace.clustering.criterion.I1Function";
    private static final String DEFAULT_REPEATS = "10";

    @Override
    public Assignments cluster(Matrix matrix, Properties properties) {
        throw new UnsupportedOperationException("DirectClustering requires the number of clusters to be set.");
    }

    @Override
    public Assignments cluster(Matrix matrix, int n, Properties properties) {
        int n2 = Integer.parseInt(properties.getProperty(REPEAT_PROPERTY, DEFAULT_REPEATS));
        KMeansSeed kMeansSeed = (KMeansSeed)ReflectionUtil.getObjectInstance(properties.getProperty(SEED_PROPERTY, DEFAULT_SEED));
        CriterionFunction criterionFunction = (CriterionFunction)ReflectionUtil.getObjectInstance(properties.getProperty(CRITERIA_PROPERTY, DEFAULT_CRITERION));
        return DirectClustering.cluster(matrix, n, n2, kMeansSeed, criterionFunction);
    }

    public static Assignments cluster(Matrix matrix, int n, int n2) {
        return DirectClustering.cluster(matrix, n, n2, new RandomSeed(), new I1Function());
    }

    public static Assignments cluster(Matrix matrix, int n, int n2, CriterionFunction criterionFunction) {
        return DirectClustering.cluster(matrix, n, n2, new RandomSeed(), criterionFunction);
    }

    public static Assignments cluster(Matrix matrix, int n, int n2, KMeansSeed kMeansSeed, CriterionFunction criterionFunction) {
        int[] nArray = null;
        double d = criterionFunction.isMaximize() ? 0.0 : Double.MAX_VALUE;
        for (int i = 0; i < n2; ++i) {
            LoggerUtil.verbose(LOGGER, "Beginning iteration %d/%d", i + 1, n2);
            DirectClustering.clusterIteration(matrix, n, kMeansSeed, criterionFunction);
            if (criterionFunction.isMaximize()) {
                if (!(criterionFunction.score() > d)) continue;
                d = criterionFunction.score();
                nArray = criterionFunction.assignments();
                continue;
            }
            if (!(criterionFunction.score() < d)) continue;
            d = criterionFunction.score();
            nArray = criterionFunction.assignments();
        }
        Assignment[] assignmentArray = new Assignment[matrix.rows()];
        for (int i = 0; i < nArray.length; ++i) {
            assignmentArray[i] = new HardAssignment((int)nArray[i]);
        }
        return new Assignments(n, assignmentArray, matrix);
    }

    private static void clusterIteration(Matrix matrix, int n, KMeansSeed kMeansSeed, CriterionFunction criterionFunction) {
        Object object;
        int n2;
        DoubleVector[] doubleVectorArray = kMeansSeed.chooseSeeds(n, matrix);
        int[] nArray = new int[matrix.rows()];
        if (n != 1) {
            int n3 = 0;
            for (n2 = 0; n2 < matrix.rows(); ++n2) {
                object = matrix.getRowVector(n2);
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    double d2 = Similarity.cosineSimilarity(doubleVectorArray[i], (DoubleVector)object);
                    ++n3;
                    if (!(d2 >= d)) continue;
                    d = d2;
                    nArray[n2] = i;
                }
            }
        }
        criterionFunction.setup(matrix, nArray, n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(matrix.rows());
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            arrayList.add(n2);
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            Collections.shuffle(arrayList);
            object = arrayList.iterator();
            while (object.hasNext()) {
                int n4 = (Integer)object.next();
                n2 |= criterionFunction.update(n4);
            }
        }
    }

    public String toString() {
        return "DirectClustering";
    }
}

