/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignment;
import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.clustering.HierarchicalAgglomerativeClustering;
import edu.ucla.sspace.clustering.SoftAssignment;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.util.BoundedSortedMultiMap;
import edu.ucla.sspace.util.Duple;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusteringByCommittee
implements Clustering {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.clustering.ClusteringByCommittee";
    public static final String AVERGAGE_LINK_MERGE_THRESHOLD_PROPERTY = "edu.ucla.sspace.clustering.ClusteringByCommittee.averageLinkMergeThreshold";
    public static final String DEFAULT_AVERGAGE_LINK_MERGE_THRESHOLD = ".25";
    public static final String COMMITTEE_SIMILARITY_THRESHOLD_PROPERTY = "edu.ucla.sspace.clustering.ClusteringByCommittee.maxCommitteeSimilarity";
    public static final String DEFAULT_COMMITTEE_SIMILARITY_THRESHOLD = ".35";
    public static final String RESIDUE_SIMILARITY_THRESHOLD_PROPERTY = "edu.ucla.sspace.clustering.ClusteringByCommittee.residueSimilarityThreshold";
    public static final String DEFAULT_RESIDUE_SIMILARITY_THRESHOLD = ".25";
    public static final String SOFT_CLUSTERING_SIMILARITY_THRESHOLD_PROPERTY = "edu.ucla.sspace.clustering.ClusteringByCommittee.softClusteringThreshold";
    public static final String DEFAULT_SOFT_CLUSTERING_SIMILARITY_THRESHOLD = ".25";
    public static final String HARD_CLUSTERING_PROPERTY = "edu.ucla.sspace.clustering.ClusteringByCommittee.useHardClustering";
    private static final Logger LOGGER = Logger.getLogger(ClusteringByCommittee.class.getName());
    private static final int K_MOST_SIMILAR_NEIGHBORS = 10;

    @Override
    public Assignments cluster(Matrix matrix, int n, Properties properties) {
        LOGGER.warning("CBC does not take in a specified number of clusters.  Ignoring specification and clustering anyway.");
        return this.cluster(matrix, properties);
    }

    @Override
    public Assignments cluster(Matrix matrix, Properties properties) {
        double d = Double.parseDouble(properties.getProperty(AVERGAGE_LINK_MERGE_THRESHOLD_PROPERTY, ".25"));
        double d2 = Double.parseDouble(properties.getProperty(COMMITTEE_SIMILARITY_THRESHOLD_PROPERTY, DEFAULT_COMMITTEE_SIMILARITY_THRESHOLD));
        double d3 = Double.parseDouble(properties.getProperty(RESIDUE_SIMILARITY_THRESHOLD_PROPERTY, ".25"));
        double d4 = Double.parseDouble(properties.getProperty(SOFT_CLUSTERING_SIMILARITY_THRESHOLD_PROPERTY, ".25"));
        boolean bl = Boolean.parseBoolean(properties.getProperty(HARD_CLUSTERING_PROPERTY, "true"));
        LOGGER.info("Starting Clustering By Committee");
        if (!(matrix instanceof SparseMatrix)) {
            throw new IllegalArgumentException("CBC only accepts sparse matrices");
        }
        SparseMatrix sparseMatrix = (SparseMatrix)matrix;
        BitSet bitSet = new BitSet(sparseMatrix.rows());
        bitSet.set(0, sparseMatrix.rows());
        LOGGER.info("CBC begining Phase 2");
        List<Committee> list = ClusteringByCommittee.phase2(sparseMatrix, bitSet, d, d2, d3);
        LOGGER.info("CBC begining Phase 3");
        Assignment[] assignmentArray = new Assignment[matrix.rows()];
        for (int i = 0; i < matrix.rows(); ++i) {
            LOGGER.fine("Computing Phase 3 for row " + i);
            SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(i);
            List<Integer> list2 = ClusteringByCommittee.phase3(sparseDoubleVector, list, bl, d4);
            int[] nArray = new int[list2.size()];
            for (int j = 0; j < list2.size(); ++j) {
                nArray[j] = list2.get(j);
            }
            assignmentArray[i] = new SoftAssignment(nArray);
        }
        return new Assignments(list.size(), assignmentArray, matrix);
    }

    private static List<Committee> phase2(SparseMatrix sparseMatrix, BitSet bitSet, double d, double d2, double d3) {
        HashSet<Integer> hashSet;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("CBC computing Phase 2 for " + bitSet.cardinality() + " rows");
        }
        ArrayList<CandidateCommittee> arrayList = new ArrayList<CandidateCommittee>();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            hashSet = new BoundedSortedMultiMap(10);
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (n != n2) {
                    double d4 = Similarity.cosineSimilarity(sparseMatrix.getRowVector(n), sparseMatrix.getRowVector(n2));
                    hashSet.put(d4, n2);
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            if (hashSet.size() != 0) {
                List<CandidateCommittee> list = ClusteringByCommittee.buildCommitteesForRow(hashSet.values(), sparseMatrix, d);
                Collections.sort(list);
                arrayList.add(list.get(0));
            }
            n = bitSet.nextSetBit(n + 1);
        }
        Collections.sort(arrayList);
        ArrayList<Committee> arrayList2 = new ArrayList<Committee>();
        for (CandidateCommittee candidateCommittee : arrayList) {
            boolean bl = true;
            for (Committee committee : arrayList2) {
                if (!(Similarity.cosineSimilarity(candidateCommittee.centroid(), committee.centroid()) >= d2)) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList2.add(new Committee(candidateCommittee));
        }
        LOGGER.log(Level.FINE, "Found {0} committees.", new Object[]{arrayList2.size()});
        if (arrayList2.isEmpty()) {
            return arrayList2;
        }
        hashSet = new HashSet<Integer>();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            boolean bl = true;
            SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(n3);
            for (Committee committee : arrayList2) {
                if (!(Similarity.cosineSimilarity(committee.centroid(), sparseDoubleVector) >= d3)) continue;
                bl = false;
            }
            if (bl) {
                hashSet.add(n3);
            }
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        if (LOGGER.isLoggable(Level.FINER) && !hashSet.isEmpty()) {
            LOGGER.finer("Found residual elements: " + hashSet);
        }
        if (hashSet.isEmpty()) {
            return arrayList2;
        }
        if (hashSet.size() == 1) {
            return arrayList2;
        }
        BitSet bitSet2 = new BitSet(sparseMatrix.rows());
        for (Integer n2 : hashSet) {
            bitSet2.set(n2);
        }
        arrayList2.addAll(ClusteringByCommittee.phase2(sparseMatrix, bitSet2, d, d2, d3));
        return arrayList2;
    }

    private static List<Integer> phase3(SparseDoubleVector sparseDoubleVector, List<Committee> list, boolean bl, double d) {
        if (bl) {
            int n = -1;
            double d2 = -1.0;
            for (int i = 0; i < list.size(); ++i) {
                Committee committee = list.get(i);
                double d3 = Similarity.cosineSimilarity(sparseDoubleVector, committee.centroid());
                if (!(d3 > d2)) continue;
                d2 = d3;
                n = i;
            }
            return Collections.singletonList(n);
        }
        CompactSparseVector compactSparseVector = new CompactSparseVector(sparseDoubleVector);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        BoundedSortedMultiMap<Double, Duple<Object, Integer>> boundedSortedMultiMap = new BoundedSortedMultiMap<Double, Duple<Object, Integer>>(200);
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            boundedSortedMultiMap.put(Similarity.cosineSimilarity(sparseDoubleVector, ((Committee)object).centroid()), new Duple<Object, Integer>(object, i));
        }
        for (Object object : boundedSortedMultiMap.values()) {
            Committee committee = (Committee)((Duple)object).x;
            Integer n = (Integer)((Duple)object).y;
            SparseDoubleVector sparseDoubleVector2 = committee.centroid();
            if (Similarity.cosineSimilarity(compactSparseVector, sparseDoubleVector2) < 0.0) continue;
            boolean bl2 = false;
            for (Integer n2 : arrayList) {
                Committee committee2 = list.get(n2);
                if (!(Similarity.cosineSimilarity(committee2.centroid(), sparseDoubleVector2) >= d)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            arrayList.add(n);
            for (Object object2 : (Object)sparseDoubleVector2.getNonZeroIndices()) {
                compactSparseVector.set((int)object2, 0.0);
            }
        }
        return arrayList;
    }

    public static List<CandidateCommittee> buildCommitteesForRow(Collection<Integer> collection, SparseMatrix sparseMatrix, double d) {
        if (collection.size() == 0) {
            return new ArrayList<CandidateCommittee>();
        }
        double d2 = 0.25;
        ArrayList<SparseDoubleVector> arrayList = new ArrayList<SparseDoubleVector>();
        for (Integer serializable2 : collection) {
            arrayList.add(sparseMatrix.getRowVector(serializable2));
        }
        Object object = HierarchicalAgglomerativeClustering.clusterRows(Matrices.asSparseMatrix(arrayList), d2, HierarchicalAgglomerativeClustering.ClusterLinkage.MEAN_LINKAGE, Similarity.SimType.COSINE);
        HashMap<Integer, HashSet<Integer>> hashMap = new HashMap<Integer, HashSet<Integer>>();
        int n = 0;
        for (Integer n2 : collection) {
            Object object2 = object[n];
            HashSet<Integer> hashSet = (HashSet<Integer>)hashMap.get((int)object2);
            if (hashSet == null) {
                hashSet = new HashSet<Integer>();
                hashMap.put((int)object2, hashSet);
            }
            hashSet.add(n2);
            ++n;
        }
        ArrayList arrayList2 = new ArrayList();
        for (Set set : hashMap.values()) {
            arrayList2.add(new CandidateCommittee(set, sparseMatrix));
        }
        return arrayList2;
    }

    private static class CandidateCommittee
    implements Comparable<CandidateCommittee> {
        private final Set<Integer> rows;
        private final SparseDoubleVector centroid;
        private final double score;

        public CandidateCommittee(Set<Integer> set, SparseMatrix sparseMatrix) {
            this.rows = set;
            this.centroid = new CompactSparseVector(sparseMatrix.columns());
            double d = 0.0;
            for (int n : set) {
                SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(n);
                VectorMath.add(this.centroid, sparseDoubleVector);
                for (int n2 : set) {
                    if (n == n2) continue;
                    d += Similarity.cosineSimilarity(sparseDoubleVector, sparseMatrix.getRowVector(n2));
                }
            }
            double d2 = 1.0 / (double)set.size();
            for (Object object : (SparseDoubleVector)this.centroid.getNonZeroIndices()) {
                this.centroid.set((int)object, this.centroid.get((int)object) / d2);
            }
            double d3 = set.size() == 1 ? 0.0 : d / (double)(set.size() * set.size() - set.size());
            this.score = (double)set.size() * d3;
        }

        public SparseDoubleVector centroid() {
            return this.centroid;
        }

        @Override
        public int compareTo(CandidateCommittee candidateCommittee) {
            return -Double.compare(this.score, candidateCommittee.score);
        }

        public boolean equals(Object object) {
            if (object instanceof CandidateCommittee) {
                CandidateCommittee candidateCommittee = (CandidateCommittee)object;
                return ((Object)candidateCommittee.rows).equals(this.rows);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.rows).hashCode();
        }

        public double score() {
            return this.score;
        }

        public String toString() {
            return "Committee {rows=" + this.rows + ", score=" + this.score + ", centroid=" + this.centroid + "}";
        }
    }

    private static class Committee {
        private final CandidateCommittee cc;

        public Committee(CandidateCommittee candidateCommittee) {
            this.cc = candidateCommittee;
        }

        public SparseDoubleVector centroid() {
            return this.cc.centroid();
        }

        public boolean equals(Object object) {
            return object instanceof Committee && ((Committee)object).cc.equals(this.cc);
        }

        public int hashCode() {
            return this.cc.hashCode();
        }

        public String toString() {
            return this.cc.toString();
        }
    }
}

