/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignment;
import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.clustering.ClutoClustering;
import edu.ucla.sspace.clustering.ClutoWrapper;
import edu.ucla.sspace.clustering.HardAssignment;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;

public class AutomaticStopClustering
implements Clustering {
    private static final Logger LOGGER = Logger.getLogger(AutomaticStopClustering.class.getName());
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.clustering.AutomaticStopClustering";
    public static final String NUM_CLUSTERS_START = "edu.ucla.sspace.clustering.AutomaticStopClustering.numClusterStart";
    public static final String NUM_CLUSTERS_END = "edu.ucla.sspace.clustering.AutomaticStopClustering.numClusterEnd";
    public static final String CLUSTERING_METHOD = "edu.ucla.sspace.clustering.AutomaticStopClustering.clusteringMethod";
    public static final String PK1_THRESHOLD = "edu.ucla.sspace.clustering.AutomaticStopClustering.pk1Threshold";
    private static final String DEFAULT_NUM_CLUSTERS_START = "1";
    private static final String DEFAULT_NUM_CLUSTERS_END = "10";
    private static final String DEFAULT_CLUSTERING_METHOD = "PK3";
    private static final String DEFAULT_PK1_THRESHOLD = "-.70";
    private static final Random random = new Random();
    private static final ClutoClustering.Method METHOD = ClutoClustering.Method.KMEANS;
    private static final ClutoClustering.Criterion CRITERION = ClutoClustering.Criterion.H2;

    @Override
    public Assignments cluster(Matrix matrix, Properties properties) {
        int n = Integer.parseInt(properties.getProperty(NUM_CLUSTERS_END, DEFAULT_NUM_CLUSTERS_END));
        return this.cluster(matrix, n, properties);
    }

    @Override
    public Assignments cluster(Matrix matrix, int n, Properties properties) {
        int n2;
        int n3 = Integer.parseInt(properties.getProperty(NUM_CLUSTERS_START, DEFAULT_NUM_CLUSTERS_START));
        int n4 = n - n3;
        Measure measure = Measure.valueOf(properties.getProperty(CLUSTERING_METHOD, DEFAULT_CLUSTERING_METHOD));
        double d = Double.parseDouble(properties.getProperty(PK1_THRESHOLD, DEFAULT_PK1_THRESHOLD));
        File file = null;
        try {
            file = File.createTempFile("cluto-input", ".matrix");
            MatrixIO.writeMatrix(matrix, file, MatrixIO.Format.CLUTO_DENSE);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        double[] dArray = new double[n4];
        File[] fileArray = new File[n4];
        String string = null;
        for (n2 = 0; n2 < n4; ++n2) {
            LOGGER.fine("Clustering with " + (n3 + n2) + " clusters");
            try {
                fileArray[n2] = File.createTempFile("autostop-clustering-out", ".matrix");
                string = ClutoWrapper.cluster(null, file, METHOD.getClutoName(), CRITERION.getClutoName(), fileArray[n2], n2 + n3);
                dArray[n2] = this.extractScore(string);
                continue;
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }
        n2 = -1;
        switch (measure) {
            case PK1: {
                n2 = this.computePk1Measure(dArray, d);
                break;
            }
            case PK2: {
                n2 = this.computePk2Measure(dArray);
                break;
            }
            case PK3: {
                n2 = this.computePk3Measure(dArray);
            }
        }
        Assignment[] assignmentArray = new HardAssignment[matrix.rows()];
        try {
            ClutoWrapper.extractAssignments(fileArray[n2], assignmentArray);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        file.delete();
        for (File file2 : fileArray) {
            file2.delete();
        }
        return new Assignments(n2, assignmentArray, matrix);
    }

    private int computePk1Measure(double[] dArray, double d) {
        int n;
        LOGGER.fine("Computing the PK1 measure");
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i];
        }
        d2 /= (double)dArray.length;
        double d3 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d3 += Math.pow(dArray[n], 2.0);
        }
        d3 /= (double)dArray.length;
        d3 = Math.sqrt(d3);
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = (dArray[n] - d2) / d3;
            if (!(dArray[n] > d)) continue;
            return n;
        }
        return 0;
    }

    private int computePk2Measure(double[] dArray) {
        LOGGER.fine("Computing the PK2 measure");
        double d = 0.0;
        for (int i = dArray.length - 1; i > 0; --i) {
            int n = i;
            dArray[n] = dArray[n] / dArray[i - 1];
            d += dArray[i];
        }
        d /= (double)(dArray.length - 1);
        double d2 = 0.0;
        for (int i = 1; i < dArray.length; ++i) {
            d2 += Math.pow(dArray[i] - d, 2.0);
        }
        d2 /= (double)(dArray.length - 2);
        d2 = Math.sqrt(d2);
        double d3 = 1.0 + d2;
        int n = 0;
        double d4 = Double.MAX_VALUE;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < d4) || !(dArray[i] >= d3)) continue;
            n = i;
            d4 = dArray[i];
        }
        return n;
    }

    private int computePk3Measure(double[] dArray) {
        LOGGER.fine("Computing the PK3 measure");
        double d = 0.0;
        double[] dArray2 = new double[dArray.length - 2];
        for (int i = 1; i < dArray.length - 1; ++i) {
            dArray2[i - 1] = 2.0 * dArray[i] / (dArray[i - 1] + dArray[i + 1]);
            d += dArray2[i - 1];
        }
        d /= (double)(dArray.length - 2);
        double d2 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d2 += Math.pow(dArray2[i] - d, 2.0);
        }
        d2 /= (double)(dArray.length - 2);
        d2 = Math.sqrt(d2);
        double d3 = 1.0 + d2;
        int n = 0;
        double d4 = Double.MAX_VALUE;
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(dArray2[i] < d4) || !(dArray2[i] >= d3)) continue;
            n = i;
            d4 = dArray2[i];
        }
        return n + 1;
    }

    private double extractScore(String string) throws IOException {
        double d = 0.0;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (!string2.contains("[I2=")) continue;
            String[] stringArray = string2.split("=");
            int n = stringArray[1].indexOf("]");
            return Double.parseDouble(stringArray[1].substring(0, n));
        }
        return 0.0;
    }

    public static enum Measure {
        PK1,
        PK2,
        PK3;

    }
}

