/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.GreekConvCaps;
import greekconverter.GreekFileConverter;
import greekconverter.MessageHandler;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Nereus
implements ActionListener,
WindowListener,
ListSelectionListener {
    private static final int INPUT_ENCODING = 0;
    private static final int OUTPUT_ENCODING = 1;
    private static final int FULL_LIST = 0;
    private static final int UNICODE_ONLY_LIST = 1;
    private GridBagLayout gridBag;
    private GridBagConstraints gridCons;
    private JFrame mainFrame;
    private JPanel mainPane;
    private JLabel srcLabel;
    private JTextField srcTf;
    private JButton srcBrowse;
    private JLabel inpEncLabel;
    private JComboBox inpEncChoice;
    private JLabel destLabel;
    private JTextField destTf;
    private JButton destBrowse;
    private JLabel outpEncLabel;
    private JComboBox outpEncChoice;
    private JLabel convLabel;
    private JList convList;
    private JScrollPane scrollPane;
    private JButton startConv;
    private JButton exitProg;
    private JFileChooser fileDlg;
    private JOptionPane msgDlg;
    private JLabel msgLevelLabel;
    private JComboBox msgLevelChoice;
    private JLabel namedEntLabel;
    private JComboBox namedEntChoice;
    private JLabel numberEntLabel;
    private JComboBox numberEntChoice;
    private GreekFileConverter gfc;

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "19-Aug-2006";
                break;
            }
            case 1: {
                info = "Swing-GUI for class GreekFileConverter";
                break;
            }
            case 2: {
                info = "Michael Neuhold <private.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Felix qui potuit rerum cognoscere causas.";
            }
        }
        return info;
    }

    private void launchFrame() {
        System.out.println("Starting " + this.getClass().getName());
        System.out.println("Version " + Nereus.getClassInfo(0));
        this.gfc = new GreekFileConverter();
        this.srcLabel = new JLabel("Source file name:");
        this.srcTf = new JTextField("", 30);
        this.srcBrowse = new JButton("Browse...");
        this.srcBrowse.addActionListener(this);
        this.inpEncLabel = new JLabel("Input file encoding:");
        this.inpEncChoice = new JComboBox();
        this.createEncodingList(0, 0);
        this.destLabel = new JLabel("Destination file name:");
        this.destTf = new JTextField("", 30);
        this.destBrowse = new JButton("Browse...");
        this.destBrowse.addActionListener(this);
        this.outpEncLabel = new JLabel("Output file encoding:");
        this.outpEncChoice = new JComboBox();
        this.createEncodingList(1, 0);
        this.convLabel = new JLabel("Conversion:");
        String[] data = new String[]{"Unicode -> Betacode", "Unicode -> ASCII", "Unicode -> HTML", "Unicode -> GreekKeys", "Unicode -> Names", "Betacode -> Unicode", "Betacode -> SPIonic", "HTML -> Unicode", "ASCII -> Betacode", "BibleWorks -> Unicode", "BibleWorks -> Betacode*", "GreekKeys -> Unicode", "Unicode -> Decomposed", "Unicode -> Precomposed"};
        this.convList = new JList<String>(data);
        this.convList.setSelectionMode(0);
        this.convList.setVisibleRowCount(5);
        this.convList.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.convList);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.startConv = new JButton("Convert");
        this.startConv.addActionListener(this);
        this.exitProg = new JButton("Exit");
        this.exitProg.addActionListener(this);
        this.msgLevelLabel = new JLabel("Messages:");
        this.msgLevelChoice = new JComboBox();
        this.msgLevelChoice.addItem("none");
        this.msgLevelChoice.addItem("errors");
        this.msgLevelChoice.addItem("status");
        this.msgLevelChoice.addItem("debug");
        this.namedEntLabel = new JLabel("Use named entities:");
        this.namedEntChoice = new JComboBox();
        this.namedEntChoice.addItem("where available");
        this.namedEntChoice.addItem("never");
        this.numberEntLabel = new JLabel("Numbers for entities are:");
        this.numberEntChoice = new JComboBox();
        this.numberEntChoice.addItem("decimal");
        this.numberEntChoice.addItem("hexadecimal");
        this.gridBag = new GridBagLayout();
        this.gridCons = new GridBagConstraints();
        this.mainFrame = new JFrame(this.getClass().getName() + " v." + Nereus.getClassInfo(0));
        this.mainPane = (JPanel)this.mainFrame.getContentPane();
        this.mainPane.setLayout(this.gridBag);
        this.gridCons.insets = new Insets(5, 5, 5, 5);
        this.gridCons.gridwidth = 1;
        this.gridCons.fill = 0;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.srcLabel, this.gridCons);
        this.mainPane.add(this.srcLabel);
        this.gridCons.fill = 3;
        this.gridBag.setConstraints(this.srcTf, this.gridCons);
        this.mainPane.add(this.srcTf);
        this.gridCons.gridwidth = 0;
        this.gridCons.fill = 0;
        this.gridCons.anchor = 10;
        this.gridBag.setConstraints(this.srcBrowse, this.gridCons);
        this.mainPane.add(this.srcBrowse);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.inpEncLabel, this.gridCons);
        this.mainPane.add(this.inpEncLabel);
        this.gridCons.gridx = -1;
        this.gridCons.gridwidth = 0;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.inpEncChoice, this.gridCons);
        this.mainPane.add(this.inpEncChoice);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.destLabel, this.gridCons);
        this.mainPane.add(this.destLabel);
        this.gridCons.fill = 3;
        this.gridBag.setConstraints(this.destTf, this.gridCons);
        this.mainPane.add(this.destTf);
        this.gridCons.gridwidth = 0;
        this.gridCons.fill = 0;
        this.gridCons.anchor = 10;
        this.gridBag.setConstraints(this.destBrowse, this.gridCons);
        this.mainPane.add(this.destBrowse);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.outpEncLabel, this.gridCons);
        this.mainPane.add(this.outpEncLabel);
        this.gridCons.gridx = -1;
        this.gridCons.gridwidth = 0;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.outpEncChoice, this.gridCons);
        this.mainPane.add(this.outpEncChoice);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.convLabel, this.gridCons);
        this.mainPane.add(this.convLabel);
        this.gridCons.gridheight = 2;
        this.gridCons.fill = 2;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.scrollPane, this.gridCons);
        this.mainPane.add(this.scrollPane);
        this.gridCons.gridheight = 1;
        this.gridCons.gridwidth = 0;
        this.gridCons.fill = 0;
        this.gridCons.anchor = 10;
        this.gridBag.setConstraints(this.startConv, this.gridCons);
        this.mainPane.add(this.startConv);
        this.gridBag.setConstraints(this.exitProg, this.gridCons);
        this.mainPane.add(this.exitProg);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.msgLevelLabel, this.gridCons);
        this.mainPane.add(this.msgLevelLabel);
        this.gridCons.gridx = -1;
        this.gridCons.gridwidth = 0;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.msgLevelChoice, this.gridCons);
        this.mainPane.add(this.msgLevelChoice);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.namedEntLabel, this.gridCons);
        this.mainPane.add(this.namedEntLabel);
        this.gridCons.gridx = -1;
        this.gridCons.gridwidth = 0;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.namedEntChoice, this.gridCons);
        this.mainPane.add(this.namedEntChoice);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.numberEntLabel, this.gridCons);
        this.mainPane.add(this.numberEntLabel);
        this.gridCons.gridx = -1;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.numberEntChoice, this.gridCons);
        this.mainPane.add(this.numberEntChoice);
        this.namedEntLabel.setVisible(false);
        this.namedEntChoice.setVisible(false);
        this.numberEntLabel.setVisible(false);
        this.numberEntChoice.setVisible(false);
        this.fileDlg = new JFileChooser();
        this.msgDlg = new JOptionPane();
        this.mainFrame.pack();
        this.mainFrame.addWindowListener(this);
        this.mainFrame.setVisible(true);
    }

    private void errMsg(String msgText, int msgType) {
        String title;
        switch (msgType) {
            case 0: {
                title = "Error";
                break;
            }
            case 1: {
                title = "Information";
                break;
            }
            case -1: {
                title = "Message";
                break;
            }
            case 2: {
                title = "Warning";
                break;
            }
            default: {
                title = "Read me";
            }
        }
        JOptionPane.showMessageDialog(this.mainFrame, msgText, title, msgType);
    }

    private void errMsg(String msgText) {
        this.errMsg(msgText, 0);
    }

    private void createEncodingList(int direction, int listtype) {
        JComboBox targetChoice = direction == 0 ? this.inpEncChoice : this.outpEncChoice;
        targetChoice.removeAllItems();
        switch (listtype) {
            case 0: {
                targetChoice.addItem("Local charset");
                targetChoice.addItem("US-ASCII");
                targetChoice.addItem("ISO-8859-1");
            }
            case 1: {
                targetChoice.addItem("UTF-8");
                targetChoice.addItem("UTF-16");
                targetChoice.addItem("UTF-16BE");
                targetChoice.addItem("UTF-16LE");
            }
        }
    }

    private int getConversionNumber(int index) {
        int convMode;
        switch (index) {
            case 0: {
                convMode = 1002;
                break;
            }
            case 1: {
                convMode = 1006;
                break;
            }
            case 2: {
                convMode = 1003;
                break;
            }
            case 3: {
                convMode = 1004;
                break;
            }
            case 4: {
                convMode = 1007;
                break;
            }
            case 5: {
                convMode = 2001;
                break;
            }
            case 6: {
                convMode = 2008;
                break;
            }
            case 7: {
                convMode = 3001;
                break;
            }
            case 8: {
                convMode = 6002;
                break;
            }
            case 9: {
                convMode = 5001;
                break;
            }
            case 10: {
                convMode = 5002;
                break;
            }
            case 11: {
                convMode = 4001;
                break;
            }
            case 12: {
                convMode = 1011;
                break;
            }
            case 13: {
                convMode = 1021;
                break;
            }
            default: {
                convMode = 0;
            }
        }
        return convMode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int retVal = 0;
        Object obj = e.getSource();
        if (obj == this.startConv) {
            String srcFile = this.srcTf.getText();
            String destFile = this.destTf.getText();
            int index = this.convList.getSelectedIndex();
            if (index == -1) {
                this.errMsg("You have to select a conversion from the list.");
                retVal = -1;
            }
            if (retVal == 0) {
                retVal = this.gfc.checkFileParams(srcFile, destFile);
            }
            if (retVal == 0) {
                String outputEnc;
                String inputEnc;
                int convMode = this.getConversionNumber(index);
                System.out.println("Converting " + srcFile + " using conversion " + this.convList.getSelectedValue() + " into " + destFile);
                if (convMode == 1003) {
                    int namedMode = this.namedEntChoice.getSelectedIndex();
                    int numberMode = this.numberEntChoice.getSelectedIndex();
                    this.gfc.setOption(1, namedMode + numberMode * 2);
                }
                if ((inputEnc = (String)this.inpEncChoice.getSelectedItem()).equals("Local charset")) {
                    inputEnc = null;
                }
                if ((outputEnc = (String)this.outpEncChoice.getSelectedItem()).equals("Local charset")) {
                    outputEnc = null;
                }
                MessageHandler.setMsgLevel(this.msgLevelChoice.getSelectedIndex() * 10);
                MessageHandler.clearMsgQueue();
                this.mainPane.setCursor(Cursor.getPredefinedCursor(3));
                retVal = this.gfc.convertFile(srcFile, destFile, convMode, inputEnc, outputEnc);
                if (this.msgLevelChoice.getSelectedIndex() > 0) {
                    MessageHandler.printMsgQueue("=== Messages Begin ===", "=== Messages End ===");
                }
                this.mainPane.setCursor(Cursor.getDefaultCursor());
            }
            if (retVal == 0) {
                System.out.println("\nDone");
                this.errMsg("Done", -1);
            } else {
                this.errMsg(this.gfc.getErrMsg());
            }
        } else if (obj == this.srcBrowse) {
            this.fileDlg.setDialogTitle("Choose source file");
            retVal = this.fileDlg.showOpenDialog(this.mainFrame);
            if (retVal == 0) {
                this.srcTf.setText(this.fileDlg.getSelectedFile().getPath());
            }
        } else if (obj == this.destBrowse) {
            this.fileDlg.setDialogTitle("Choose destination file");
            retVal = this.fileDlg.showSaveDialog(this.mainFrame);
            if (retVal == 0) {
                this.destTf.setText(this.fileDlg.getSelectedFile().getPath());
            }
        } else if (obj == this.exitProg) {
            System.out.println("Good bye.");
            System.exit(0);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.out.println("Good bye.");
        System.exit(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.convList.getSelectedIndex();
        int convMode = this.getConversionNumber(index);
        int convFrom = GreekConvCaps.getConvInput(convMode);
        int convInto = GreekConvCaps.getConvOutput(convMode);
        switch (convFrom) {
            case 1: {
                this.createEncodingList(0, 1);
                this.inpEncLabel.setEnabled(true);
                this.inpEncChoice.setEnabled(true);
                break;
            }
            case 4: {
                this.createEncodingList(0, 0);
                this.inpEncLabel.setEnabled(false);
                this.inpEncChoice.setEnabled(false);
                break;
            }
            default: {
                this.createEncodingList(0, 0);
                this.inpEncLabel.setEnabled(true);
                this.inpEncChoice.setEnabled(true);
            }
        }
        switch (convInto) {
            case 1: {
                this.createEncodingList(1, 1);
                this.outpEncLabel.setEnabled(true);
                this.outpEncChoice.setEnabled(true);
                break;
            }
            case 4: {
                this.createEncodingList(1, 0);
                this.outpEncLabel.setEnabled(false);
                this.outpEncChoice.setEnabled(false);
                break;
            }
            default: {
                this.createEncodingList(1, 0);
                this.outpEncLabel.setEnabled(true);
                this.outpEncChoice.setEnabled(true);
            }
        }
        if (convInto == 3) {
            this.namedEntLabel.setVisible(true);
            this.namedEntChoice.setVisible(true);
            this.numberEntLabel.setVisible(true);
            this.numberEntChoice.setVisible(true);
            this.mainFrame.pack();
        } else {
            this.namedEntLabel.setVisible(false);
            this.namedEntChoice.setVisible(false);
            this.numberEntLabel.setVisible(false);
            this.numberEntChoice.setVisible(false);
            this.mainFrame.pack();
        }
    }

    public static void main(String[] args) {
        Nereus nereus = new Nereus();
        nereus.launchFrame();
    }
}

