/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekParser;
import java.util.Properties;
import java.util.TreeMap;

public class SPIonicParser
extends AbstractGreekParser {
    protected static final String ENCODING = "US-ASCII";
    private Properties bcp;
    private Properties ga;
    private StringBuffer strb = new StringBuffer();
    private TreeMap map = new TreeMap();

    public SPIonicParser() {
        this.bcp = new Properties();
        this.ga = new Properties();
        try {
            Class<?> c = this.getClass();
            this.bcp.load(c.getResourceAsStream("SPIonicParser.properties"));
            this.ga.load(c.getResourceAsStream("GreekAccents.properties"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public String next() {
        this.strb.delete(0, this.strb.length());
        if (this.in != null) {
            char ch = this.chArray[this.index];
            ++this.index;
            this.map.clear();
            this.strb.append(this.lookup(ch));
            while (this.hasNext() && this.isSPIonicDiacritical(this.chArray[this.index])) {
                this.strb.append("_" + this.lookup(this.chArray[this.index]));
                ++this.index;
            }
        }
        return this.strb.toString();
    }

    private String lookup(char ch) {
        String key = String.valueOf(ch);
        return this.bcp.getProperty(key, key);
    }

    private String lookupAccent(char ch) {
        return this.ga.getProperty(this.lookup(ch));
    }

    private boolean isSPIonicDiacritical(char ch) {
        switch (ch) {
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '+': 
            case '/': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '9': 
            case '<': 
            case '=': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }
}

