/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekConverter;
import edu.unc.epidoc.transcoder.Parser;
import java.util.Properties;

public class BetaCodeConverter
extends AbstractGreekConverter {
    protected Properties bcc;

    public BetaCodeConverter() {
        this.encoding = "US-ASCII";
        this.bcc = new Properties();
        try {
            Class<?> c = this.getClass();
            this.bcc.load(c.getResourceAsStream("BetaCodeConverter.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String convertToCharacterEntities(Parser in) {
        StringBuffer result = new StringBuffer();
        char[] chars = this.convertToString(in).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch > '\u007f') {
                result.append("&#x" + Integer.toHexString(ch) + ";");
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    public String convertToString(Parser in) {
        StringBuffer result = new StringBuffer();
        while (in.hasNext()) {
            String convert = in.next();
            if (convert.indexOf(95) > 0 && convert.length() > 1) {
                int i;
                String[] elements = this.split(convert);
                String temp = this.bcc.getProperty(elements[0], this.unrec);
                if (temp.charAt(0) == '*') {
                    result.append(temp.charAt(0));
                    for (i = 1; i < elements.length; ++i) {
                        result.append(this.bcc.getProperty(elements[i], this.unrec));
                    }
                    result.append(temp.substring(1));
                    continue;
                }
                for (i = 0; i < elements.length; ++i) {
                    result.append(this.bcc.getProperty(elements[i], this.unrec));
                }
                continue;
            }
            if (convert.length() > 1) {
                result.append(this.bcc.getProperty(convert, this.unrec));
                continue;
            }
            result.append(this.bcc.getProperty(convert, convert));
        }
        return result.toString();
    }
}

