/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.Factorize;
import jnt.FFT.RealDoubleFFT;

public class RealDoubleFFT_Radix2
extends RealDoubleFFT {
    private int logn;

    public RealDoubleFFT_Radix2(int n) {
        super(n);
        this.logn = Factorize.log2(n);
        if (this.logn < 0) {
            throw new IllegalArgumentException(n + " is not a power of 2");
        }
    }

    @Override
    public void transform(double[] dArray, int n, int n2) {
        this.checkData(dArray, n, n2);
        if (this.n == 1) {
            return;
        }
        this.bitreverse(dArray, n, n2);
        int n3 = 1;
        int n4 = this.n;
        for (int i = 1; i <= this.logn; ++i) {
            double d;
            double d2;
            int n5;
            int n6 = n3;
            n3 = 2 * n3;
            n4 /= 2;
            for (n5 = 0; n5 < n4; ++n5) {
                d2 = dArray[n + n2 * n5 * n3] + dArray[n + n2 * (n5 * n3 + n6)];
                d = dArray[n + n2 * n5 * n3] - dArray[n + n2 * (n5 * n3 + n6)];
                dArray[n + n2 * n5 * n3] = d2;
                dArray[n + n2 * (n5 * n3 + n6)] = d;
            }
            d2 = 1.0;
            d = 0.0;
            double d3 = Math.PI * -2 / (double)n3;
            double d4 = Math.sin(d3);
            double d5 = Math.sin(d3 / 2.0);
            double d6 = 2.0 * d5 * d5;
            for (int j = 1; j < n6 / 2; ++j) {
                double d7 = d2 - d4 * d - d6 * d2;
                double d8 = d + d4 * d2 - d6 * d;
                d2 = d7;
                d = d8;
                for (n5 = 0; n5 < n4; ++n5) {
                    d7 = dArray[n + n2 * (n5 * n3 + j)];
                    d8 = dArray[n + n2 * (n5 * n3 + n6 - j)];
                    double d9 = dArray[n + n2 * (n5 * n3 + n6 + j)];
                    double d10 = dArray[n + n2 * (n5 * n3 + n3 - j)];
                    dArray[n + n2 * (n5 * n3 + j)] = d7 + d2 * d9 - d * d10;
                    dArray[n + n2 * (n5 * n3 + n3 - j)] = d8 + d2 * d10 + d * d9;
                    dArray[n + n2 * (n5 * n3 + n6 - j)] = d7 - d2 * d9 + d * d10;
                    dArray[n + n2 * (n5 * n3 + n6 + j)] = -(d8 - d2 * d10 - d * d9);
                }
            }
            if (n6 <= 1) continue;
            for (n5 = 0; n5 < n4; ++n5) {
                int n7 = n + n2 * (n5 * n3 + n3 - n6 / 2);
                dArray[n7] = dArray[n7] * -1.0;
            }
        }
    }

    @Override
    public void backtransform(double[] dArray, int n, int n2) {
        this.checkData(dArray, n, n2);
        if (this.n == 1) {
            return;
        }
        int n3 = this.n;
        int n4 = 1;
        int n5 = this.n / 2;
        for (int i = 1; i <= this.logn; ++i) {
            double d;
            double d2;
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                d2 = dArray[n + n2 * n6 * n3];
                d = dArray[n + n2 * (n6 * n3 + n5)];
                dArray[n + n2 * n6 * n3] = d2 + d;
                dArray[n + n2 * (n6 * n3 + n5)] = d2 - d;
            }
            d2 = 1.0;
            d = 0.0;
            double d3 = Math.PI * 2 / (double)n3;
            double d4 = Math.sin(d3);
            double d5 = Math.sin(d3 / 2.0);
            double d6 = 2.0 * d5 * d5;
            for (int j = 1; j < n5 / 2; ++j) {
                double d7 = d2 - d4 * d - d6 * d2;
                double d8 = d + d4 * d2 - d6 * d;
                d2 = d7;
                d = d8;
                for (n6 = 0; n6 < n4; ++n6) {
                    double d9 = dArray[n + n2 * (n6 * n3 + j)];
                    double d10 = dArray[n + n2 * (n6 * n3 + n3 - j)];
                    double d11 = dArray[n + n2 * (n6 * n3 + n5 - j)];
                    double d12 = -dArray[n + n2 * (n6 * n3 + n5 + j)];
                    dArray[n + n2 * (n6 * n3 + j)] = d9 + d11;
                    dArray[n + n2 * (n6 * n3 + n5 - j)] = d10 + d12;
                    double d13 = d9 - d11;
                    double d14 = d10 - d12;
                    dArray[n + n2 * (n6 * n3 + n5 + j)] = d2 * d13 - d * d14;
                    dArray[n + n2 * (n6 * n3 + n3 - j)] = d2 * d14 + d * d13;
                }
            }
            if (n5 > 1) {
                for (n6 = 0; n6 < n4; ++n6) {
                    int n7 = n + n2 * (n6 * n3 + n5 / 2);
                    dArray[n7] = dArray[n7] * 2.0;
                    int n8 = n + n2 * (n6 * n3 + n5 + n5 / 2);
                    dArray[n8] = dArray[n8] * -2.0;
                }
            }
            n5 /= 2;
            n3 /= 2;
            n4 *= 2;
        }
        this.bitreverse(dArray, n, n2);
    }

    @Override
    public double[] toWraparoundOrder(double[] dArray) {
        return this.toWraparoundOrder(dArray, 0, 1);
    }

    @Override
    public double[] toWraparoundOrder(double[] dArray, int n, int n2) {
        this.checkData(dArray, n, n2);
        double[] dArray2 = new double[2 * this.n];
        int n3 = this.n / 2;
        dArray2[0] = dArray[n];
        dArray2[1] = 0.0;
        dArray2[this.n] = dArray[n + n2 * n3];
        dArray2[this.n + 1] = 0.0;
        for (int i = 1; i < n3; ++i) {
            dArray2[2 * i] = dArray[n + n2 * i];
            dArray2[2 * i + 1] = dArray[n + n2 * (this.n - i)];
            dArray2[2 * (this.n - i)] = dArray[n + n2 * i];
            dArray2[2 * (this.n - i) + 1] = -dArray[n + n2 * (this.n - i)];
        }
        return dArray2;
    }

    protected void bitreverse(double[] dArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.n - 1; ++i) {
            int n4 = this.n / 2;
            if (i < n3) {
                double d = dArray[n + n2 * i];
                dArray[n + n2 * i] = dArray[n + n2 * n3];
                dArray[n + n2 * n3] = d;
            }
            while (n4 <= n3) {
                n3 -= n4;
                n4 /= 2;
            }
            n3 += n4;
        }
    }
}

