/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexDoubleFFT;
import jnt.FFT.ComplexDoubleFFT_Mixed;
import jnt.FFT.RealDoubleFFT;

public class RealDoubleFFT_Even
extends RealDoubleFFT {
    ComplexDoubleFFT fft;

    public RealDoubleFFT_Even(int n) {
        super(n);
        if (n % 2 != 0) {
            throw new IllegalArgumentException(n + " is not even");
        }
        this.fft = new ComplexDoubleFFT_Mixed(n / 2);
    }

    @Override
    public void transform(double[] dArray) {
        this.fft.transform(dArray);
        this.shuffle(dArray, 1);
    }

    @Override
    public double[] toWraparoundOrder(double[] dArray) {
        double[] dArray2 = new double[2 * this.n];
        int n = this.n / 2;
        dArray2[0] = dArray[0];
        dArray2[1] = 0.0;
        dArray2[this.n] = dArray[1];
        dArray2[this.n + 1] = 0.0;
        for (int i = 1; i < n; ++i) {
            dArray2[2 * i] = dArray[2 * i];
            dArray2[2 * i + 1] = dArray[2 * i + 1];
            dArray2[2 * (this.n - i)] = dArray[2 * i];
            dArray2[2 * (this.n - i) + 1] = -dArray[2 * i + 1];
        }
        return dArray2;
    }

    @Override
    public double[] toWraparoundOrder(double[] dArray, int n, int n2) {
        throw new Error("Not Implemented!");
    }

    @Override
    public void backtransform(double[] dArray) {
        this.shuffle(dArray, -1);
        this.fft.backtransform(dArray);
    }

    private void shuffle(double[] dArray, int n) {
        int n2 = this.n / 2;
        int n3 = this.n / 4;
        double d = 0.5;
        double d2 = -0.5 * (double)n;
        double d3 = (double)n * Math.PI / (double)n2;
        double d4 = Math.sin(0.5 * d3);
        double d5 = -2.0 * d4 * d4;
        double d6 = -Math.sin(d3);
        double d7 = 1.0 + d5;
        double d8 = d6;
        for (int i = 1; i < n3; ++i) {
            int n4 = 2 * i;
            int n5 = this.n - n4;
            double d9 = d * (dArray[n4] + dArray[n5]);
            double d10 = d * (dArray[n4 + 1] - dArray[n5 + 1]);
            double d11 = -d2 * (dArray[n4 + 1] + dArray[n5 + 1]);
            double d12 = d2 * (dArray[n4] - dArray[n5]);
            dArray[n4] = d9 + d7 * d11 - d8 * d12;
            dArray[n4 + 1] = d10 + d7 * d12 + d8 * d11;
            dArray[n5] = d9 - d7 * d11 + d8 * d12;
            dArray[n5 + 1] = -d10 + d7 * d12 + d8 * d11;
            d4 = d7;
            d7 += d4 * d5 - d8 * d6;
            d8 += d4 * d6 + d8 * d5;
        }
        double d13 = dArray[0];
        if (n == 1) {
            dArray[0] = d13 + dArray[1];
            dArray[1] = d13 - dArray[1];
        } else {
            dArray[0] = d * (d13 + dArray[1]);
            dArray[1] = d * (d13 - dArray[1]);
        }
        if (this.n % 4 == 0) {
            int n6 = n2 + 1;
            dArray[n6] = dArray[n6] * -1.0;
        }
    }

    @Override
    public void transform(double[] dArray, int n, int n2) {
        throw new Error("Not Implemented!");
    }

    @Override
    public void backtransform(double[] dArray, int n, int n2) {
        throw new Error("Not Implemented!");
    }

    @Override
    public void inverse(double[] dArray, int n, int n2) {
        throw new Error("Not Implemented!");
    }

    @Override
    public double normalization() {
        return 2.0 / (double)this.n;
    }

    @Override
    public void inverse(double[] dArray) {
        this.backtransform(dArray);
        double d = this.normalization();
        int n = 0;
        while (n < this.n) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
    }
}

