/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi.semeval;

import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.wordsi.ContextExtractor;
import edu.ucla.sspace.wordsi.ContextGenerator;
import edu.ucla.sspace.wordsi.Wordsi;
import java.io.BufferedReader;
import java.util.ArrayDeque;
import java.util.Iterator;

public class SemEvalContextExtractor
implements ContextExtractor {
    private static final String DEFAULT_SEPARATOR = "||||";
    private final ContextGenerator generator;
    private final int windowSize;
    private final String separator;

    public SemEvalContextExtractor(ContextGenerator contextGenerator, int n) {
        this(contextGenerator, n, DEFAULT_SEPARATOR);
    }

    public SemEvalContextExtractor(ContextGenerator contextGenerator, int n, String string) {
        this.generator = contextGenerator;
        this.windowSize = n;
        this.separator = string;
    }

    @Override
    public int getVectorLength() {
        return this.generator.getVectorLength();
    }

    @Override
    public void processDocument(BufferedReader bufferedReader, Wordsi wordsi) {
        Object object;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>();
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        if (!iterator.hasNext()) {
            return;
        }
        String string = iterator.next();
        int n = 0;
        while (iterator.hasNext() && !((String)(object = iterator.next())).equals(this.separator)) {
            arrayDeque.offer(((String)object).intern());
            ++n;
        }
        while (arrayDeque.size() > this.windowSize) {
            arrayDeque.remove();
        }
        if (!iterator.hasNext()) {
            return;
        }
        String string2 = iterator.next().intern();
        while (iterator.hasNext() && arrayDeque2.size() < this.windowSize) {
            arrayDeque2.offer(iterator.next().intern());
        }
        object = this.generator.generateContext(arrayDeque, arrayDeque2);
        wordsi.handleContextVector(string2, string, (SparseDoubleVector)object);
    }
}

