/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.SparseVector;
import java.io.Serializable;
import java.util.Arrays;

public class TernaryVector
implements SparseVector<Integer>,
IntegerVector,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int[] positiveDimensions;
    protected int[] negativeDimensions;
    private int length;

    public TernaryVector(int n, int[] nArray, int[] nArray2) {
        this.length = n;
        this.positiveDimensions = nArray;
        this.negativeDimensions = nArray2;
        Arrays.sort(this.positiveDimensions);
        Arrays.sort(this.negativeDimensions);
    }

    @Override
    public int add(int n, int n2) {
        throw new UnsupportedOperationException("TernaryVector instances cannot be modified");
    }

    @Override
    public int get(int n) {
        if (n < 0 || n > this.length) {
            throw new IndexOutOfBoundsException("index not within vector: " + n);
        }
        if (Arrays.binarySearch(this.positiveDimensions, n) >= 0) {
            return 1;
        }
        if (Arrays.binarySearch(this.negativeDimensions, n) >= 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int[] getNonZeroIndices() {
        int[] nArray = new int[this.negativeDimensions.length + this.positiveDimensions.length];
        System.arraycopy(this.negativeDimensions, 0, nArray, 0, this.negativeDimensions.length);
        System.arraycopy(this.positiveDimensions, 0, nArray, this.negativeDimensions.length, this.positiveDimensions.length);
        return nArray;
    }

    @Override
    public Integer getValue(int n) {
        return this.get(n);
    }

    @Override
    public int length() {
        return this.length;
    }

    public int[] negativeDimensions() {
        return this.negativeDimensions;
    }

    public int[] positiveDimensions() {
        return this.positiveDimensions;
    }

    @Override
    public double magnitude() {
        return Math.sqrt(this.positiveDimensions.length + this.negativeDimensions.length);
    }

    @Override
    public void set(int n, int n2) {
        throw new UnsupportedOperationException("TernaryVector instances cannot be modified");
    }

    @Override
    public void set(int n, Number number) {
        throw new UnsupportedOperationException("TernaryVector instances cannot be modified");
    }

    @Override
    public int[] toArray() {
        int[] nArray = new int[this.length];
        for (int n : this.positiveDimensions) {
            nArray[n] = 1;
        }
        for (int n : this.negativeDimensions) {
            nArray[n] = -1;
        }
        return nArray;
    }
}

