/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.util.DoubleEntry;
import edu.ucla.sspace.util.ObjectEntry;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashVector;
import edu.ucla.sspace.vector.SparseVector;
import java.io.Serializable;
import java.util.Iterator;

public class SparseHashDoubleVector
extends SparseHashVector<Double>
implements SparseDoubleVector,
Iterable<DoubleEntry>,
Serializable {
    private static final long serialVersionUID = 1L;

    public SparseHashDoubleVector(int n) {
        super(n);
    }

    public SparseHashDoubleVector(double[] dArray) {
        super(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            this.vector.set(i, dArray[i]);
        }
    }

    public SparseHashDoubleVector(DoubleVector doubleVector) {
        super(doubleVector.length());
        if (doubleVector instanceof SparseVector) {
            int[] nArray;
            for (int n : nArray = ((SparseVector)((Object)doubleVector)).getNonZeroIndices()) {
                this.vector.set(n, doubleVector.get(n));
            }
        } else {
            for (int i = 0; i < doubleVector.length(); ++i) {
                double d = doubleVector.get(i);
                if (d == 0.0) continue;
                this.vector.set(i, d);
            }
        }
    }

    @Override
    public double add(int n, double d) {
        double d2 = this.get(n);
        this.set(n, d2 + d);
        return d2 + d;
    }

    @Override
    public double get(int n) {
        Number number = (Number)this.vector.get(n);
        return number == null ? 0.0 : number.doubleValue();
    }

    @Override
    public Double getValue(int n) {
        return this.get(n);
    }

    @Override
    public Iterator<DoubleEntry> iterator() {
        return new DoubleIterator();
    }

    @Override
    public void set(int n, double d) {
        this.vector.set(n, d);
        this.magnitude = -1.0;
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.length()];
        for (int n : this.vector.getElementIndices()) {
            dArray[n] = ((Number)this.vector.get(n)).doubleValue();
        }
        return dArray;
    }

    class DoubleIterator
    implements Iterator<DoubleEntry> {
        Iterator<ObjectEntry<Number>> it;

        public DoubleIterator() {
            this.it = SparseHashDoubleVector.this.vector.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public DoubleEntry next() {
            final ObjectEntry<Number> objectEntry = this.it.next();
            return new DoubleEntry(){

                @Override
                public int index() {
                    return objectEntry.index();
                }

                @Override
                public double value() {
                    return ((Number)objectEntry.value()).doubleValue();
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from vector");
        }
    }
}

