/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.VectorView;
import java.io.Serializable;

class IntAsDoubleVector
extends VectorView<Double>
implements DoubleVector,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IntegerVector intVector;

    public IntAsDoubleVector(IntegerVector integerVector) {
        this(integerVector, 0, integerVector.length(), false);
    }

    public IntAsDoubleVector(IntegerVector integerVector, boolean bl) {
        this(integerVector, 0, integerVector.length(), bl);
    }

    public IntAsDoubleVector(IntegerVector integerVector, int n, int n2) {
        this(integerVector, n, n2, false);
    }

    public IntAsDoubleVector(IntegerVector integerVector, int n, int n2, boolean bl) {
        super(integerVector, n, n2, bl);
        this.intVector = integerVector;
    }

    @Override
    public double add(int n, double d) {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Cannot modify an immutable vector");
        }
        return this.intVector.add(this.getIndex(n), (int)d);
    }

    @Override
    public void set(int n, double d) {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Cannot modify an immutable vector");
        }
        this.intVector.set(this.getIndex(n), (int)d);
    }

    @Override
    public double get(int n) {
        return this.intVector.get(this.getIndex(n));
    }

    @Override
    public Double getValue(int n) {
        return this.get(n);
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.vectorLength - this.vectorOffset];
        for (int i = this.vectorOffset; i < this.vectorLength; ++i) {
            dArray[i] = this.intVector.get(i);
        }
        return dArray;
    }
}

