/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.IntegerVector;
import java.io.Serializable;
import java.util.Arrays;

public class DenseIntVector
implements IntegerVector,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] vector;

    public DenseIntVector(int n) {
        this.vector = new int[n];
    }

    public DenseIntVector(IntegerVector integerVector) {
        this.vector = new int[integerVector.length()];
        for (int i = 0; i < integerVector.length(); ++i) {
            this.vector[i] = integerVector.get(i);
        }
    }

    public DenseIntVector(int[] nArray) {
        this.vector = Arrays.copyOf(nArray, nArray.length);
    }

    @Override
    public int add(int n, int n2) {
        int n3 = n;
        this.vector[n3] = this.vector[n3] + n2;
        return this.vector[n];
    }

    @Override
    public int get(int n) {
        return this.vector[n];
    }

    @Override
    public Integer getValue(int n) {
        return this.get(n);
    }

    @Override
    public int length() {
        return this.vector.length;
    }

    @Override
    public double magnitude() {
        double d = 0.0;
        int[] nArray = this.vector;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double d2 = nArray[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    @Override
    public void set(int n, int n2) {
        this.vector[n] = n2;
    }

    @Override
    public void set(int n, Number number) {
        this.set(n, number.intValue());
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.vector, this.vector.length);
    }
}

