/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.WorkerThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class WorkQueue {
    private final List<Thread> threads;
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private final ConcurrentMap<Object, CountDownLatch> taskKeyToLatch;

    public WorkQueue() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public WorkQueue(int n) {
        this.threads = new ArrayList<Thread>();
        this.taskKeyToLatch = new ConcurrentHashMap<Object, CountDownLatch>();
        for (int i = 0; i < n; ++i) {
            WorkerThread workerThread = new WorkerThread(this.workQueue);
            this.threads.add(workerThread);
            workerThread.start();
        }
    }

    public void add(Object object, Runnable runnable) {
        CountDownLatch countDownLatch = (CountDownLatch)this.taskKeyToLatch.get(object);
        if (countDownLatch == null) {
            throw new IllegalArgumentException("Unknown task id: " + object);
        }
        this.workQueue.offer(new CountingRunnable(runnable, countDownLatch));
    }

    public void await(Object object) {
        CountDownLatch countDownLatch = (CountDownLatch)this.taskKeyToLatch.get(object);
        if (countDownLatch == null) {
            throw new IllegalArgumentException("Unknown task group: " + object);
        }
        try {
            while (!countDownLatch.await(5L, TimeUnit.SECONDS)) {
            }
            this.taskKeyToLatch.remove(object);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Not all tasks finished", interruptedException);
        }
    }

    public boolean await(Object object, long l, TimeUnit timeUnit) {
        CountDownLatch countDownLatch = (CountDownLatch)this.taskKeyToLatch.get(object);
        if (countDownLatch == null) {
            throw new IllegalArgumentException("Unknown task group: " + object);
        }
        try {
            if (countDownLatch.await(l, timeUnit)) {
                this.taskKeyToLatch.remove(object);
                return true;
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Not all tasks finished", interruptedException);
        }
    }

    public Object registerTaskGroup(int n) {
        Object object = new Object();
        this.taskKeyToLatch.putIfAbsent(object, new CountDownLatch(n));
        return object;
    }

    public boolean registerTaskGroup(Object object, int n) {
        return this.taskKeyToLatch.putIfAbsent(object, new CountDownLatch(n)) == null;
    }

    public void run(Runnable ... runnableArray) {
        this.run(Arrays.asList(runnableArray));
    }

    public void run(Collection<Runnable> collection) {
        int n = collection.size();
        CountDownLatch countDownLatch = new CountDownLatch(n);
        for (Runnable runnable : collection) {
            this.workQueue.offer(new CountingRunnable(runnable, countDownLatch));
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Not all tasks finished", interruptedException);
        }
    }

    public int numThreads() {
        return this.threads.size();
    }

    private static class CountingRunnable
    implements Runnable {
        private final Runnable task;
        private final CountDownLatch latch;

        public CountingRunnable(Runnable runnable, CountDownLatch countDownLatch) {
            this.task = runnable;
            this.latch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.task.run();
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

