/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class SerializableUtil {
    private SerializableUtil() {
    }

    public static void save(Object object, String string) {
        SerializableUtil.save(object, new File(string));
    }

    public static void save(Object object, File file) {
        try {
            SerializableUtil.save(object, new FileOutputStream(file));
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public static void save(Object object, OutputStream outputStream) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public static <T> T load(File file, Class<T> clazz) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return (T)object;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOError(classNotFoundException);
        }
    }

    public static <T> T load(String string) {
        return SerializableUtil.load(new File(string));
    }

    public static <T> T load(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return (T)object;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOError(classNotFoundException);
        }
    }

    public static <T> T load(InputStream inputStream) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return (T)object;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOError(classNotFoundException);
        }
    }
}

