/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.util.Iterator;

public class LimitedIterator<T>
implements Iterator<T> {
    private final Iterator<T> iter;
    private int itemCount;
    private final int maxItems;

    public LimitedIterator(Iterator<T> iterator, int n) {
        this.iter = iterator;
        this.maxItems = n;
        this.itemCount = 0;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.itemCount < this.maxItems && this.iter.hasNext();
    }

    @Override
    public synchronized T next() {
        ++this.itemCount;
        return this.iter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }
}

