/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CharMap<V>
extends AbstractMap<Character, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    char[] keyIndices;
    Object[] values;

    public CharMap() {
        this.keyIndices = new char[0];
        this.values = new Object[0];
    }

    public CharMap(Map<Character, ? extends V> map) {
        int n;
        this.keyIndices = new char[map.size()];
        this.values = new Object[map.size()];
        Iterator<Character> iterator = map.keySet().iterator();
        for (n = 0; n < map.size(); ++n) {
            this.keyIndices[n] = iterator.next().charValue();
        }
        Arrays.sort(this.keyIndices);
        for (n = 0; n < this.keyIndices.length; ++n) {
            this.values[n] = map.get(Character.valueOf(this.keyIndices[n]));
        }
    }

    private char checkKey(Object object) {
        if (object == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (!(object instanceof Character)) {
            throw new IllegalArgumentException("key must be an Character");
        }
        return ((Character)object).charValue();
    }

    @Override
    public void clear() {
        this.keyIndices = new char[0];
        this.values = new Object[0];
    }

    @Override
    public boolean containsKey(Object object) {
        char c = this.checkKey(object);
        int n = Arrays.binarySearch(this.keyIndices, c);
        return n >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        for (Object object2 : this.values) {
            if (object2 != object && (object2 == null || !object2.equals(object))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<Character, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public V get(Object object) {
        char c = this.checkKey(object);
        return this.get(c);
    }

    public V get(char c) {
        int n = Arrays.binarySearch(this.keyIndices, c);
        return (V)(n >= 0 ? this.values[n] : null);
    }

    @Override
    public Set<Character> keySet() {
        return new KeySet();
    }

    @Override
    public V put(Character c, V v) {
        char c2 = this.checkKey(c);
        return this.put(c2, v);
    }

    @Override
    public V put(char c, V v) {
        char c2 = c;
        int n = Arrays.binarySearch(this.keyIndices, c2);
        if (n >= 0) {
            Object object = this.values[n];
            this.values[n] = v;
            return (V)object;
        }
        int n2 = 0 - (n + 1);
        Object[] objectArray = Arrays.copyOf(this.values, this.values.length + 1);
        char[] cArray = Arrays.copyOf(this.keyIndices, this.values.length + 1);
        for (int i = n2; i < this.values.length; ++i) {
            objectArray[i + 1] = this.values[i];
            cArray[i + 1] = this.keyIndices[i];
        }
        objectArray[n2] = v;
        cArray[n2] = c2;
        this.values = objectArray;
        this.keyIndices = cArray;
        return null;
    }

    @Override
    public V remove(Object object) {
        char c = this.checkKey(object);
        return this.remove(c);
    }

    public V remove(char c) {
        char c2 = c;
        int n = Arrays.binarySearch(this.keyIndices, c2);
        if (n >= 0) {
            Object object = this.values[n];
            Object[] objectArray = Arrays.copyOf(this.values, this.values.length - 1);
            char[] cArray = Arrays.copyOf(this.keyIndices, this.keyIndices.length - 1);
            for (int i = n; i < this.values.length - 1; ++i) {
                objectArray[i] = this.values[i + 1];
                cArray[i] = this.keyIndices[i + 1];
            }
            this.values = objectArray;
            this.keyIndices = cArray;
            return (V)object;
        }
        return null;
    }

    @Override
    public int size() {
        return this.keyIndices.length;
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    private class Values
    extends AbstractCollection<V> {
        private static final long serialVersionUID = 1L;

        private Values() {
        }

        @Override
        public void clear() {
            CharMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return CharMap.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return CharMap.this.size();
        }
    }

    class KeySet
    extends AbstractSet<Character> {
        private static final long serialVersionUID = 1L;

        @Override
        public void clear() {
            CharMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return CharMap.this.containsKey(object);
        }

        @Override
        public Iterator<Character> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            return CharMap.this.remove(object) != null;
        }

        @Override
        public int size() {
            return CharMap.this.size();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<Character, V>> {
        private static final long serialVersionUID = 1L;

        EntrySet() {
        }

        @Override
        public void clear() {
            CharMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                Object v2 = CharMap.this.get(k);
                return v2 == v || v != null && v.equals(v2);
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<Character, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return CharMap.this.size();
        }
    }

    class CharEntry
    extends AbstractMap.SimpleEntry<Character, V> {
        private static final long serialVersionUID = 1L;

        public CharEntry(char c, V v) {
            super(Character.valueOf(c), v);
        }

        @Override
        public V setValue(V v) {
            return CharMap.this.put((Character)this.getKey(), v);
        }
    }

    abstract class CharMapIterator<E>
    implements Iterator<E> {
        private int next = 0;

        @Override
        public boolean hasNext() {
            return this.next < CharMap.this.size();
        }

        public Map.Entry<Character, V> nextEntry() {
            if (this.next >= CharMap.this.size()) {
                throw new NoSuchElementException("no further elements");
            }
            char c = CharMap.this.keyIndices[this.next];
            Object object = CharMap.this.values[this.next];
            ++this.next;
            return new CharEntry(c, object);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueIterator
    extends CharMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends CharMapIterator<Character> {
        private KeyIterator() {
        }

        @Override
        public Character next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends CharMapIterator<Map.Entry<Character, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<Character, V> next() {
            return this.nextEntry();
        }
    }
}

