/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SvdlibjDriver;
import java.io.File;
import java.io.IOError;
import java.io.IOException;

public class SvdTool {
    public static void main(String[] stringArray) {
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('h', "help", "Generates a help message and exits", false, null, "Program Options");
        argOptions.addOption('d', "dimensions", "Desired SVD Triples", true, "INT", "Program Options");
        argOptions.addOption('o', "fileRoot", "Root of files in which to store resulting U,S,V", true, "DIR", "Program Options");
        argOptions.addOption('r', "inputFormat", "Input matrix file format", true, "STRING", "Program Options");
        argOptions.addOption('w', "outputFormat", "Output matrix file format", true, "STRING", "Program Options");
        argOptions.parseOptions(stringArray);
        if (argOptions.numPositionalArgs() == 0 || argOptions.hasOption("help")) {
            SvdTool.usage(argOptions);
            return;
        }
        int n = argOptions.getIntOption('d');
        String string = argOptions.getPositionalArg(0);
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException("non-existent input matrix file: " + string);
        }
        String string2 = argOptions.getStringOption('o');
        File file2 = new File(string2);
        if (!file2.exists() || !file2.isDirectory()) {
            throw new IllegalArgumentException("invalid output directory: " + string2);
        }
        MatrixIO.Format format = argOptions.hasOption('r') ? SvdTool.getFormat(argOptions.getStringOption('r')) : MatrixIO.Format.SVDLIBC_SPARSE_TEXT;
        MatrixIO.Format format2 = argOptions.hasOption('w') ? SvdTool.getFormat(argOptions.getStringOption('w')) : MatrixIO.Format.SVDLIBC_DENSE_TEXT;
        try {
            Matrix[] matrixArray = SvdlibjDriver.svd(file, format, n);
            File file3 = new File(file2, "U.mat");
            File file4 = new File(file2, "S.mat");
            File file5 = new File(file2, "V.mat");
            MatrixIO.writeMatrix(matrixArray[0], file3, format2);
            MatrixIO.writeMatrix(matrixArray[1], file4, format2);
            MatrixIO.writeMatrix(matrixArray[2], file5, format2);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private static MatrixIO.Format getFormat(String string) {
        if (string.equals("cd")) {
            return MatrixIO.Format.CLUTO_DENSE;
        }
        if (string.equals("cs")) {
            return MatrixIO.Format.CLUTO_SPARSE;
        }
        if (string.equals("ms")) {
            return MatrixIO.Format.MATLAB_SPARSE;
        }
        if (string.equals("db")) {
            return MatrixIO.Format.SVDLIBC_DENSE_BINARY;
        }
        if (string.equals("dt")) {
            return MatrixIO.Format.SVDLIBC_DENSE_TEXT;
        }
        if (string.equals("sb")) {
            return MatrixIO.Format.SVDLIBC_SPARSE_BINARY;
        }
        if (string.equals("st")) {
            return MatrixIO.Format.SVDLIBC_SPARSE_TEXT;
        }
        throw new IllegalArgumentException("unrecognized format: " + string);
    }

    private static void usage(ArgOptions argOptions) {
        System.out.println("SVD version 1.0\n  Based on SVDLIBJ, written by Adrian Kuhn and David Erni,\n  which was adapted from SVDLIBC, written by Doug Rohde,\n  which was based on code adapted from SVDPACKC\n\nusage: java -jar svd.jar [options] matrix_file\n\n" + argOptions.prettyPrint() + "\nValid matrix formats are:\n" + "  cd        The sparse text format supported by CLUTO.\n" + "  cs        The sparse text format supported by CLUTO.\n" + "  ms        The sparse format supported by Matlab.\n" + "  db        The dense binary format supported by SVDLIBC.\n" + "  dt        The dense text format supported by SVDLIBC. (default output)\n" + "  sb        The sparse binary format supported by SVDLIBC.\n" + "  st        The sparse text format supported by SVDLIBC. (default input)\n" + "\nSee http://tedlab.mit.edu/~dr/SVDLIBC/ for more format details");
    }
}

