/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.basis.StringBasisMapping;
import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyExtractorManager;
import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyPathWeight;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.FilteredDependencyIterator;
import edu.ucla.sspace.dependency.FlatPathWeight;
import edu.ucla.sspace.dependency.UniversalPathAcceptor;
import edu.ucla.sspace.mains.DependencyGenericMain;
import edu.ucla.sspace.matrix.AtomicGrowingSparseHashMatrix;
import edu.ucla.sspace.matrix.NoTransform;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.matrix.Transform;
import edu.ucla.sspace.util.BoundedSortedMap;
import edu.ucla.sspace.util.Pair;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DependencyBasisMaker
extends DependencyGenericMain {
    @Override
    public void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('b', "basisSize", "Specifies the total desired size of the basis (Default: 10000)", true, "INT", "Optional");
        argOptions.addOption('a', "pathAcceptor", "Specifies the dependency path acceptor to use. (Default:    UnivseralPathAcceptor)", true, "CLASSNAME", "Optional");
        argOptions.addOption('w', "pathWeighter", "Specifies the dependency path weighter to use. (Default:    FlatPathWeight)", true, "CLASSNAME", "Optional");
        argOptions.addOption('l', "pathLength", "Specifies the maximum dependency path length. (Default:    5)", true, "INT", "Optional");
    }

    @Override
    protected SemanticSpace getSpace() {
        this.setupDependencyExtractor();
        int n = this.argOptions.getIntOption('b', 10000);
        Transform transform = this.argOptions.getObjectOption('T', new NoTransform());
        DependencyPathAcceptor dependencyPathAcceptor = this.argOptions.getObjectOption('a', new UniversalPathAcceptor());
        DependencyPathWeight dependencyPathWeight = this.argOptions.getObjectOption('w', new FlatPathWeight());
        int n2 = this.argOptions.getIntOption('l', 5);
        return new OccurrenceCounter(transform, n, dependencyPathAcceptor, dependencyPathWeight, n2);
    }

    @Override
    protected void saveSSpace(SemanticSpace semanticSpace, File file) throws IOException {
        StringBasisMapping stringBasisMapping = new StringBasisMapping();
        for (String string : semanticSpace.getWords()) {
            stringBasisMapping.getDimension(string);
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(stringBasisMapping);
        objectOutputStream.close();
    }

    public class OccurrenceCounter
    implements SemanticSpace {
        private final AtomicGrowingSparseHashMatrix cooccurrenceMatrix = new AtomicGrowingSparseHashMatrix();
        private final BasisMapping<String, String> basis = new StringBasisMapping();
        private final Map<String, Double> wordScores;
        private final Transform transform;
        private final DependencyPathAcceptor acceptor;
        private final DependencyPathWeight weighter;
        private final int pathLength;
        private final DependencyExtractor extractor;

        public OccurrenceCounter(Transform transform, int n, DependencyPathAcceptor dependencyPathAcceptor, DependencyPathWeight dependencyPathWeight, int n2) {
            this.wordScores = new BoundedSortedMap<String, Double>(n);
            this.extractor = DependencyExtractorManager.getDefaultExtractor();
            this.transform = transform;
            this.acceptor = dependencyPathAcceptor;
            this.weighter = dependencyPathWeight;
            this.pathLength = n2;
        }

        @Override
        public void processDocument(BufferedReader bufferedReader) throws IOException {
            Object object;
            HashMap<Pair<Integer>, Double> hashMap = new HashMap<Pair<Integer>, Double>();
            Object object2 = null;
            while ((object2 = this.extractor.readNextTree(bufferedReader)) != null) {
                if (((DependencyTreeNode[])object2).length == 0) continue;
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object = object2[i].word();
                    int n = this.basis.getDimension((String)object);
                    FilteredDependencyIterator filteredDependencyIterator = new FilteredDependencyIterator((DependencyTreeNode)object2[i], this.acceptor, this.pathLength);
                    while (filteredDependencyIterator.hasNext()) {
                        DependencyPath dependencyPath = (DependencyPath)filteredDependencyIterator.next();
                        String string = dependencyPath.last().word();
                        int n2 = this.basis.getDimension(string);
                        double d = this.weighter.scorePath(dependencyPath);
                        hashMap.put(new Pair<Integer>(n, n2), d);
                    }
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (Pair)entry.getKey();
                this.cooccurrenceMatrix.addAndGet((Integer)((Pair)object).x, (Integer)((Pair)object).y, (Double)entry.getValue());
            }
        }

        @Override
        public Set<String> getWords() {
            return Collections.unmodifiableSet(this.wordScores.keySet());
        }

        @Override
        public DoubleVector getVector(String string) {
            Double d = this.wordScores.get(string);
            return d == null ? new DenseVector(new double[]{0.0}) : new DenseVector(new double[]{d});
        }

        @Override
        public int getVectorLength() {
            return 1;
        }

        @Override
        public void processSpace(Properties properties) {
            SparseMatrix sparseMatrix = (SparseMatrix)this.transform.transform(this.cooccurrenceMatrix);
            for (String string : this.basis.keySet()) {
                int n = this.basis.getDimension(string);
                SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(n);
                double d = 0.0;
                for (int n2 : sparseDoubleVector.getNonZeroIndices()) {
                    d += sparseDoubleVector.get(n2);
                }
                this.wordScores.put(string, d);
            }
        }

        @Override
        public String getSpaceName() {
            return "BasisMaker";
        }
    }
}

