/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.clustering.Assignment;
import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.StaticSemanticSpace;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.ScaledDoubleVector;
import edu.ucla.sspace.vector.Vectors;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class ClusterSSpace {
    public static void main(String[] stringArray) throws Exception {
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('s', "sspace", "The semantic space to be clustered", true, "FILE", "Required");
        argOptions.addOption('a', "clusteringAlgorithm", "The clustering algorithm to use", true, "CLASSNAME", "Required");
        argOptions.addOption('c', "numClusters", "The number of clusters to use", true, "INT", "Optional");
        argOptions.parseOptions(stringArray);
        if (!argOptions.hasOption('a') || !argOptions.hasOption('s')) {
            System.out.println("Usage: ClusterSSpace\n" + argOptions.prettyPrint());
            System.exit(1);
        }
        Clustering clustering = (Clustering)ReflectionUtil.getObjectInstance(argOptions.getStringOption('a'));
        StaticSemanticSpace staticSemanticSpace = new StaticSemanticSpace(argOptions.getStringOption('s'));
        int n = argOptions.getIntOption('c', 0);
        Set<String> set = staticSemanticSpace.getWords();
        ArrayList<DoubleVector> arrayList = new ArrayList<DoubleVector>();
        for (String object2 : set) {
            if (staticSemanticSpace.getVector(object2) instanceof ScaledDoubleVector) {
                System.out.println("whaaat the fuuuu");
            }
            arrayList.add(Vectors.asDouble(staticSemanticSpace.getVector(object2)));
        }
        Matrix matrix = Matrices.asMatrix(arrayList);
        Properties properties = System.getProperties();
        Assignments assignments = n > 0 ? clustering.cluster(matrix, n, properties) : clustering.cluster(matrix, properties);
        int n2 = 0;
        for (String string : set) {
            Assignment assignment = assignments.get(n2++);
            System.out.printf("%s ", string);
            for (int n3 : assignment.assignments()) {
                System.out.printf("%d ", n3);
            }
            System.out.println();
        }
    }
}

