/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.util.HashMultiMap;
import edu.ucla.sspace.util.MultiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChildesParser {
    private PrintWriter writer;
    private PrintWriter posWriter;
    private MultiMap<String, String> posTags;
    private final boolean generateAugmented;
    private final boolean separateByPeriod;
    private final boolean appendPosTags;
    private final boolean generateOneDoc;

    public ChildesParser(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.generateAugmented = bl;
        this.separateByPeriod = bl2;
        this.appendPosTags = bl3;
        this.generateOneDoc = bl4;
        this.posTags = new HashMultiMap<String, String>();
        try {
            this.writer = new PrintWriter(string);
            this.posWriter = new PrintWriter(string2);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private synchronized void print(String string) {
        if (this.generateOneDoc) {
            this.writer.print(string);
        } else {
            this.writer.println(string);
        }
    }

    public void parseFile(File file, boolean bl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("u");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getElementsByTagName("w");
                StringBuilder stringBuilder2 = new StringBuilder();
                ArrayList<String> arrayList = new ArrayList<String>(nodeList2.getLength());
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    object4 = (Element)nodeList2.item(j);
                    object3 = object4.getElementsByTagName("pos");
                    object2 = object4.getFirstChild().getNodeValue();
                    if (object3.getLength() > 0) {
                        object = object3.item(0).getFirstChild().getFirstChild();
                        string = object.getNodeValue();
                        this.posTags.put((String)object2, string);
                        if (this.appendPosTags) {
                            object2 = object2 + "-" + string;
                        }
                    }
                    arrayList.add((String)object2);
                }
                NodeList nodeList3 = element.getElementsByTagName("a");
                object4 = new LinkedList();
                if (this.generateAugmented) {
                    for (int j = 0; j < nodeList3.getLength(); ++j) {
                        object2 = nodeList3.item(j);
                        object = object2.getAttributes().getNamedItem("type").getNodeValue();
                        if (!((String)object).equals("action") && !((String)object).equals("actions") && !((String)object).equals("addressee") && !((String)object).equals("comments") && !((String)object).equals("explanation") && !((String)object).equals("gesture") && !((String)object).equals("happening") && !((String)object).equals("situation")) continue;
                        string = object2.getFirstChild().getNodeValue();
                        Iterator<String> iterator = IteratorFactory.tokenize(new BufferedReader(new StringReader(string)));
                        while (iterator.hasNext()) {
                            String string2 = iterator.next();
                            for (String string3 : arrayList) {
                                object4.add(string3 + " " + string2 + "-GROUNDING");
                            }
                        }
                    }
                }
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    stringBuilder2.append((String)object3.next());
                    if (!object3.hasNext()) continue;
                    stringBuilder2.append(" ");
                }
                object3 = stringBuilder2.toString();
                if (bl) {
                    this.print((String)object3);
                    object2 = object4.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        this.print((String)object);
                    }
                    continue;
                }
                stringBuilder.append((String)object3);
                if (this.separateByPeriod) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(" ");
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    this.print((String)object);
                }
            }
            if (!bl) {
                this.print(stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void finish() {
        for (Map.Entry<String, String> entry : this.posTags.entrySet()) {
            this.posWriter.println(entry.getKey() + " " + entry.getValue());
        }
        this.posWriter.flush();
        this.posWriter.close();
        this.writer.flush();
        this.writer.close();
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('p', "partOfSpeechTag", "If set, each token will be appended with it's part of speech tag, such as cat-noun", false, null, "Optional");
        argOptions.addOption('S', "separateByPeriod", "If set, seperates sentences by periods", false, null, "Optional");
        argOptions.addOption('U', "utterancePerDoc", "If set, one utterance is considered a document, otherwise all uterances in a file will be considered a document", false, null, "Optional");
        argOptions.addOption('g', "generateOneDoc", "If set, only one document will be generated for all the text processed", false, null, "Optional");
        argOptions.addOption('A', "augmentedUtterances", "Generates augmented utterances from comments about the utterances", false, null, "Augmented");
        argOptions.addOption('F', "augmentedUtterancesFilter", "Specifes a token filter for which tokens in comments are used to generate augmented utterances", true, "SPEC", "Augmented");
        argOptions.addOption('d', "baseChildesDirectory", "The base childes directory.  XML files will be searched for recursively from this base.  Use of this overrides the fileList option.", true, "DIRECTORY", "Required (At least one of)");
        argOptions.addOption('f', "fileList", "The list of files to process", true, "FILE[,FILE]*", "Required (At least one of)");
        argOptions.parseOptions(stringArray);
        if (!argOptions.hasOption("fileList") && !argOptions.hasOption("baseChildesDirectory") || argOptions.numPositionalArgs() != 2) {
            System.out.println("usage: java ChildesParser [options] <outfile> <pos-file>\n" + argOptions.prettyPrint());
            return;
        }
        boolean bl = false;
        bl = argOptions.hasOption("utterancePerDoc");
        boolean bl2 = argOptions.hasOption("augmentedUtterances");
        if (bl2 && argOptions.hasOption("augmentedUtterancesFilter")) {
            object2 = argOptions.getStringOption("augmentedUtterancesFilter");
            object = System.getProperties();
            object.setProperty("edu.ucla.sspace.text.TokenizerFactory.tokenFilter", (String)object2);
            IteratorFactory.setProperties((Properties)object);
        }
        object2 = new ChildesParser(argOptions.getPositionalArg(0), argOptions.getPositionalArg(1), bl2, argOptions.hasOption('S'), argOptions.hasOption('p'), argOptions.hasOption('g'));
        if (argOptions.hasOption("fileList")) {
            for (String string : object = argOptions.getStringOption("fileList").split(",")) {
                ((ChildesParser)object2).parseFile(new File(string), bl);
            }
        } else {
            object = new File(argOptions.getStringOption("baseChildesDirectory"));
            ChildesParser.findXmlFiles((ChildesParser)object2, bl, (File)object);
        }
        ((ChildesParser)object2).finish();
    }

    public static void findXmlFiles(ChildesParser childesParser, boolean bl, File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                ChildesParser.findXmlFiles(childesParser, bl, file2);
                continue;
            }
            if (!file2.isFile() || !file2.getPath().endsWith(".xml")) continue;
            childesParser.parseFile(file2, bl);
        }
    }
}

