/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.basis.StringBasisMapping;
import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.hal.LinearWeighting;
import edu.ucla.sspace.hal.WeightingFunction;
import edu.ucla.sspace.mains.GenericMain;
import edu.ucla.sspace.matrix.AtomicGrowingSparseHashMatrix;
import edu.ucla.sspace.matrix.NoTransform;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.matrix.Transform;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.util.BoundedSortedMap;
import edu.ucla.sspace.util.Pair;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;

public class BasisMaker
extends GenericMain {
    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('T', "matrixTransform", "Specifies the matrix transform that should be applied to co-occurrence counts after they have been generated", true, "CLASSNAME", "Optional");
        argOptions.addOption('b', "basisSize", "Specifies the total desired size of the basis (Default: 10000)", true, "INT", "Optional");
        argOptions.addOption('w', "windowSize", "Specifies the sliding window size (Default: 5)", true, "INT", "Optional");
        argOptions.addOption('p', "printWeights", "If true, each saved word and it's associated weight will be printed to standard out", false, null, "Optional");
    }

    @Override
    protected SemanticSpace getSpace() {
        Transform transform = null;
        transform = this.argOptions.hasOption('T') ? (Transform)ReflectionUtil.getObjectInstance(this.argOptions.getStringOption('T')) : new NoTransform();
        int n = this.argOptions.getIntOption('b', 10000);
        int n2 = this.argOptions.getIntOption('w', 5);
        return new OccurrenceCounter(transform, n, n2);
    }

    @Override
    protected void saveSSpace(SemanticSpace semanticSpace, File file) throws IOException {
        StringBasisMapping stringBasisMapping = new StringBasisMapping();
        for (String string : semanticSpace.getWords()) {
            stringBasisMapping.getDimension(string);
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(stringBasisMapping);
        objectOutputStream.close();
    }

    public class OccurrenceCounter
    implements SemanticSpace {
        private final AtomicGrowingSparseHashMatrix cooccurrenceMatrix = new AtomicGrowingSparseHashMatrix();
        private final WeightingFunction weighting;
        private final BasisMapping<String, String> basis = new StringBasisMapping();
        private final Map<String, Double> wordScores;
        private final Transform transform;
        private final int windowSize;

        public OccurrenceCounter(Transform transform, int n, int n2) {
            this.wordScores = new BoundedSortedMap<String, Double>(n);
            this.weighting = new LinearWeighting();
            this.transform = transform;
            this.windowSize = n2;
        }

        @Override
        public void processDocument(BufferedReader bufferedReader) throws IOException {
            int n;
            ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
            ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>();
            Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
            String string = null;
            HashMap<Pair<Integer>, Double> hashMap = new HashMap<Pair<Integer>, Double>();
            for (n = 0; n < this.windowSize && iterator.hasNext(); ++n) {
                arrayDeque.offer(iterator.next());
            }
            while (!arrayDeque.isEmpty()) {
                string = (String)arrayDeque.remove();
                if (iterator.hasNext()) {
                    arrayDeque.offer(iterator.next());
                }
                if (string.equals("")) {
                    n = this.basis.getDimension(string);
                    this.countOccurrences(arrayDeque, n, 1, hashMap);
                    this.countOccurrences(arrayDeque2, n, -arrayDeque2.size(), hashMap);
                }
                arrayDeque2.offer(string);
                if (arrayDeque2.size() <= this.windowSize) continue;
                arrayDeque2.remove();
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                Pair pair = (Pair)entry.getKey();
                this.cooccurrenceMatrix.addAndGet((Integer)pair.x, (Integer)pair.y, (Double)entry.getValue());
            }
        }

        private void countOccurrences(Queue<String> queue, int n, int n2, Map<Pair<Integer>, Double> map) {
            for (String string : queue) {
                if (!string.equals("")) {
                    int n3 = this.basis.getDimension(string);
                    Pair<Integer> pair = new Pair<Integer>(n, n3);
                    double d = this.weighting.weight(n2, this.windowSize);
                    Double d2 = map.get(pair);
                    map.put(pair, d2 == null ? d : d + d2);
                }
                ++n2;
            }
        }

        @Override
        public Set<String> getWords() {
            return Collections.unmodifiableSet(this.wordScores.keySet());
        }

        @Override
        public DoubleVector getVector(String string) {
            Double d = this.wordScores.get(string);
            return d == null ? new DenseVector(new double[]{0.0}) : new DenseVector(new double[]{d});
        }

        @Override
        public int getVectorLength() {
            return 1;
        }

        @Override
        public void processSpace(Properties properties) {
            SparseMatrix sparseMatrix = (SparseMatrix)this.transform.transform(this.cooccurrenceMatrix);
            for (String string : this.basis.keySet()) {
                int n = this.basis.getDimension(string);
                SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(n);
                double d = 0.0;
                for (int n2 : sparseDoubleVector.getNonZeroIndices()) {
                    d += sparseDoubleVector.get(n2);
                }
                this.wordScores.put(string, d);
            }
        }

        @Override
        public String getSpaceName() {
            return "BasisMaker";
        }
    }
}

