/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text.corpora;

import edu.ucla.sspace.text.DirectoryCorpusReader;
import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.text.DocumentPreprocessor;
import edu.ucla.sspace.text.StringDocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;

public class UsenetCorpusReader
extends DirectoryCorpusReader<Document> {
    private static final String END_OF_DOCUMENT = "---END.OF.DOCUMENT---";

    public UsenetCorpusReader() {
    }

    public UsenetCorpusReader(DocumentPreprocessor documentPreprocessor) {
        super(documentPreprocessor);
    }

    @Override
    protected Iterator<Document> corpusIterator(Iterator<File> iterator) {
        return new UseNetIterator(iterator);
    }

    public class UseNetIterator
    extends DirectoryCorpusReader.BaseFileIterator {
        private BufferedReader usenetReader;
        private final boolean useTimestamps;

        public UseNetIterator(Iterator<File> iterator) {
            super(iterator);
            this.useTimestamps = false;
        }

        @Override
        protected void setupCurrentDoc(File file) {
            try {
                this.usenetReader = new BufferedReader(new FileReader(file));
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }

        protected Document advanceInDoc() {
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                while ((string = this.usenetReader.readLine()) != null) {
                    if (string.contains(UsenetCorpusReader.END_OF_DOCUMENT)) {
                        return new StringDocument(this.cleanDoc(stringBuilder.toString()));
                    }
                    int n = 0;
                    char c = string.charAt(n);
                    while (n < string.length() && (c == '>' || c == ' ')) {
                        c = string.charAt(++n);
                    }
                    stringBuilder.append(string.substring(n)).append(" ");
                }
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
            return null;
        }
    }
}

