/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text.corpora;

import edu.ucla.sspace.text.CorpusReader;
import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.text.EnglishStemmer;
import edu.ucla.sspace.text.Stemmer;
import edu.ucla.sspace.text.StringDocument;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class SemEvalCorpusReader
extends DefaultHandler
implements CorpusReader<Document> {
    @Override
    public Iterator<Document> read(Reader reader) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        try {
            sAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            SemEvalHandler semEvalHandler = new SemEvalHandler();
            sAXParser.parse(new InputSource(reader), (DefaultHandler)semEvalHandler);
            return semEvalHandler.contexts.iterator();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new RuntimeException(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new RuntimeException(sAXNotSupportedException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    @Override
    public Iterator<Document> read(File file) {
        try {
            return this.read(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOError(fileNotFoundException);
        }
    }

    public class SemEvalHandler
    extends DefaultHandler {
        List<Document> contexts = new ArrayList<Document>();
        private boolean inContext = false;
        private String instanceId;
        private String lemma;
        private StringBuilder context = new StringBuilder();
        private final Stemmer stemmer = new EnglishStemmer();

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!(string3.endsWith(".train") || string3.endsWith(".test") || this.inContext)) {
                this.inContext = true;
                this.instanceId = string3;
                String[] stringArray = this.instanceId.split("\\.");
                this.lemma = this.stemmer.stem(stringArray[0]);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals(this.instanceId)) {
                this.inContext = false;
                String[] stringArray = this.context.toString().split("\\s+");
                this.context.setLength(0);
                this.context.append(this.instanceId).append(" ");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = this.stemmer.stem(stringArray[i]);
                    if (string4.equals(this.lemma)) {
                        this.context.append("|||| ");
                        stringArray[i] = this.lemma;
                    }
                    this.context.append(stringArray[i]).append(" ");
                }
                this.contexts.add(new StringDocument(this.context.toString()));
                this.context.setLength(0);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.inContext) {
                this.context.append(new String(cArray, n, n2));
            }
        }
    }
}

