/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WordIterator
implements Iterator<String> {
    private static final Pattern notWhiteSpace = Pattern.compile("\\S+");
    private final BufferedReader br;
    private String next;
    private Matcher matcher;
    private String curLine;

    public WordIterator(String string) {
        this(new BufferedReader(new StringReader(string)));
    }

    public WordIterator(BufferedReader bufferedReader) {
        this.br = bufferedReader;
        this.curLine = null;
        this.advance();
    }

    private void advance() {
        try {
            while (this.curLine == null || !this.matcher.find()) {
                String string = this.br.readLine();
                if (string == null) {
                    this.next = null;
                    this.br.close();
                    return;
                }
                this.matcher = notWhiteSpace.matcher(string);
                this.curLine = string;
                if (!this.matcher.find()) continue;
            }
            this.next = this.curLine.substring(this.matcher.start(), this.matcher.end());
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        String string = this.next;
        this.advance();
        return string;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }
}

