/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatPho {
    private static final Map<String, double[]> PHONEME_VALUES = new HashMap<String, double[]>();
    private static final Set<String> VOWELS = new HashSet<String>();
    private static final Set<String> CONSONANTS = new HashSet<String>();
    private final int[] consonantIndices;
    private final int[] vowelIndices;

    public PatPho() {
        this(true);
    }

    public PatPho(boolean bl) {
        int n;
        int n2 = (bl ? 18 : 9) + 3;
        int n3 = bl ? 12 : 6;
        this.consonantIndices = new int[n2];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (n % 3 == 0) {
                n4 += 2;
            }
            this.consonantIndices[n] = n4++;
        }
        this.vowelIndices = new int[n3];
        n4 = 4;
        for (n = 0; n < n3; ++n) {
            if (n % 2 == 0) {
                n4 += 3;
            }
            this.vowelIndices[n] = n4++;
        }
    }

    public double[] vectorize(String string) {
        return Arrays.copyOfRange(PHONEME_VALUES.get(string), 0, 3);
    }

    public double[] vectorize(List<String> list) {
        int n = 0;
        int n2 = 0;
        double[] dArray = new double[(this.vowelIndices.length + this.consonantIndices.length) * 3];
        for (String string : list) {
            int n3 = 3;
            n3 = VOWELS.contains(string) ? (n3 *= this.vowelIndices[n2++]) : (n3 *= this.consonantIndices[n++]);
            double[] dArray2 = PHONEME_VALUES.get(string);
            for (int i = 0; i < 3; ++i) {
                dArray[i + n3] = dArray2[i];
            }
        }
        return dArray;
    }

    static {
        PHONEME_VALUES.put("i", new double[]{0.1, 0.1, 0.1});
        PHONEME_VALUES.put("I", new double[]{0.1, 0.1, 0.185});
        PHONEME_VALUES.put("e", new double[]{0.1, 0.1, 0.27});
        PHONEME_VALUES.put("E", new double[]{0.1, 0.1, 0.355});
        PHONEME_VALUES.put("&", new double[]{0.1, 0.1, 0.444});
        PHONEME_VALUES.put("@", new double[]{0.1, 0.175, 0.185});
        PHONEME_VALUES.put("3", new double[]{0.1, 0.175, 0.27});
        PHONEME_VALUES.put("V", new double[]{0.1, 0.175, 0.355});
        PHONEME_VALUES.put("a", new double[]{0.1, 0.175, 0.444});
        PHONEME_VALUES.put("u", new double[]{0.1, 0.25, 0.1});
        PHONEME_VALUES.put("U", new double[]{0.1, 0.25, 0.185});
        PHONEME_VALUES.put("O", new double[]{0.1, 0.25, 0.27});
        PHONEME_VALUES.put("Q", new double[]{0.1, 0.25, 0.355});
        PHONEME_VALUES.put("A", new double[]{0.1, 0.25, 0.444});
        VOWELS.add("i");
        VOWELS.add("I");
        VOWELS.add("e");
        VOWELS.add("E");
        VOWELS.add("&");
        VOWELS.add("@");
        VOWELS.add("3");
        VOWELS.add("V");
        VOWELS.add("a");
        VOWELS.add("u");
        VOWELS.add("U");
        VOWELS.add("O");
        VOWELS.add("Q");
        VOWELS.add("A");
        PHONEME_VALUES.put("p", new double[]{1.0, 0.45, 0.733});
        PHONEME_VALUES.put("t", new double[]{1.0, 0.684, 0.733});
        PHONEME_VALUES.put("k", new double[]{1.0, 0.921, 0.733});
        PHONEME_VALUES.put("b", new double[]{0.75, 0.45, 0.733});
        PHONEME_VALUES.put("d", new double[]{0.75, 0.684, 0.733});
        PHONEME_VALUES.put("g", new double[]{0.75, 0.921, 0.733});
        PHONEME_VALUES.put("m", new double[]{0.75, 0.45, 0.644});
        PHONEME_VALUES.put("n", new double[]{0.75, 0.684, 0.644});
        PHONEME_VALUES.put("N", new double[]{0.75, 0.921, 0.644});
        PHONEME_VALUES.put("l", new double[]{0.75, 0.684, 1.0});
        PHONEME_VALUES.put("r", new double[]{0.75, 0.684, 0.911});
        PHONEME_VALUES.put("f", new double[]{1.0, 0.528, 0.822});
        PHONEME_VALUES.put("v", new double[]{0.75, 0.528, 0.822});
        PHONEME_VALUES.put("s", new double[]{1.0, 0.684, 0.822});
        PHONEME_VALUES.put("z", new double[]{0.75, 0.684, 0.822});
        PHONEME_VALUES.put("S", new double[]{1.0, 0.792, 0.822});
        PHONEME_VALUES.put("Z", new double[]{0.75, 0.792, 0.822});
        PHONEME_VALUES.put("j", new double[]{0.75, 0.841, 0.911});
        PHONEME_VALUES.put("h", new double[]{1.0, 1.0, 0.911});
        PHONEME_VALUES.put("w", new double[]{0.75, 0.921, 0.911});
        PHONEME_VALUES.put("T", new double[]{1.0, 0.606, 0.822});
        PHONEME_VALUES.put("D", new double[]{0.75, 0.606, 0.822});
        PHONEME_VALUES.put("C", new double[]{1.0, 0.841, 0.822});
        PHONEME_VALUES.put("J", new double[]{0.75, 0.841, 0.822});
        CONSONANTS.add("p");
        CONSONANTS.add("t");
        CONSONANTS.add("k");
        CONSONANTS.add("b");
        CONSONANTS.add("d");
        CONSONANTS.add("g");
        CONSONANTS.add("m");
        CONSONANTS.add("n");
        CONSONANTS.add("N");
        CONSONANTS.add("l");
        CONSONANTS.add("r");
        CONSONANTS.add("f");
        CONSONANTS.add("v");
        CONSONANTS.add("s");
        CONSONANTS.add("z");
        CONSONANTS.add("S");
        CONSONANTS.add("Z");
        CONSONANTS.add("j");
        CONSONANTS.add("h");
        CONSONANTS.add("w");
        CONSONANTS.add("T");
        CONSONANTS.add("D");
        CONSONANTS.add("C");
        CONSONANTS.add("J");
    }
}

