/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.text.TokenFilter;
import edu.ucla.sspace.text.WordIterator;
import java.io.BufferedReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OrderPreservingFilteredIterator
implements Iterator<String> {
    private final Iterator<String> tokenizer;
    private final TokenFilter filter;
    private String next;

    public OrderPreservingFilteredIterator(String string, TokenFilter tokenFilter) {
        this(new WordIterator(string), tokenFilter);
    }

    public OrderPreservingFilteredIterator(BufferedReader bufferedReader, TokenFilter tokenFilter) {
        this(new WordIterator(bufferedReader), tokenFilter);
    }

    public OrderPreservingFilteredIterator(Iterator<String> iterator, TokenFilter tokenFilter) {
        this.tokenizer = iterator;
        this.filter = tokenFilter;
        this.next = null;
        this.advance();
    }

    private void advance() {
        String string = null;
        if (this.tokenizer.hasNext()) {
            String string2 = this.tokenizer.next();
            string = this.filter.accept(string2) ? string2 : "";
        }
        this.next = string;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        String string = this.next;
        this.advance();
        return string;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }
}

