/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.text.CompoundWordIterator;
import edu.ucla.sspace.text.FilteredIterator;
import edu.ucla.sspace.text.OrderPreservingFilteredIterator;
import edu.ucla.sspace.text.Stemmer;
import edu.ucla.sspace.text.StemmingIterator;
import edu.ucla.sspace.text.TokenFilter;
import edu.ucla.sspace.text.WordIterator;
import edu.ucla.sspace.text.WordReplacementIterator;
import edu.ucla.sspace.util.FileResourceFinder;
import edu.ucla.sspace.util.LimitedIterator;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.util.ResourceFinder;
import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IteratorFactory {
    public static final String EMPTY_TOKEN = "";
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.text.TokenizerFactory";
    public static final String TOKEN_FILTER_PROPERTY = "edu.ucla.sspace.text.TokenizerFactory.tokenFilter";
    public static final String STEMMER_PROPERTY = "edu.ucla.sspace.text.TokenizerFactory.stemmer";
    public static final String COMPOUND_TOKENS_FILE_PROPERTY = "edu.ucla.sspace.text.TokenizerFactory.compoundTokens";
    public static final String TOKEN_REPLACEMENT_FILE_PROPERTY = "edu.ucla.sspace.text.TokenizerFactory.replacementTokens";
    public static final String TOKEN_COUNT_LIMIT_PROPERTY = "edu.ucla.sspace.text.TokenizerFactory.tokenCountLimit";
    public static final Set<String> ITERATOR_FACTORY_PROPERTIES = new HashSet<String>();
    private static TokenFilter filter;
    private static ResourceFinder resourceFinder;
    private static Stemmer stemmer;
    private static int wordLimit;
    private static Map<String, String> replacementMap;
    private static final Map<Thread, CompoundWordIterator> compoundIterators;
    private static Set<String> compoundTokens;

    private IteratorFactory() {
    }

    public static synchronized void setProperties(Properties properties) {
        Object object;
        Iterator<Map.Entry<Thread, CompoundWordIterator>> iterator;
        Object object2;
        String string;
        wordLimit = Integer.parseInt(properties.getProperty(TOKEN_COUNT_LIMIT_PROPERTY, "0"));
        String string2 = properties.getProperty(TOKEN_FILTER_PROPERTY);
        filter = string2 != null ? TokenFilter.loadFromSpecification(string2, resourceFinder) : null;
        String string3 = properties.getProperty(STEMMER_PROPERTY);
        if (string3 != null) {
            stemmer = (Stemmer)ReflectionUtil.getObjectInstance(string3);
        }
        if ((string = properties.getProperty(COMPOUND_TOKENS_FILE_PROPERTY)) != null) {
            compoundTokens = new LinkedHashSet<String>();
            try {
                object2 = resourceFinder.open(string);
                iterator = null;
                while ((iterator = ((BufferedReader)object2).readLine()) != null) {
                    compoundTokens.add((String)((Object)iterator));
                }
                for (Map.Entry<Thread, CompoundWordIterator> object3 : compoundIterators.entrySet()) {
                    object = new BufferedReader(new StringReader(EMPTY_TOKEN));
                    object3.setValue(new CompoundWordIterator((BufferedReader)object, compoundTokens));
                }
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        } else {
            compoundTokens = null;
        }
        if ((object2 = properties.getProperty(TOKEN_REPLACEMENT_FILE_PROPERTY)) != null) {
            try {
                String string4;
                iterator = resourceFinder.open((String)object2);
                replacementMap = new HashMap<String, String>();
                Object var6_9 = null;
                while ((string4 = ((BufferedReader)((Object)iterator)).readLine()) != null) {
                    object = string4.split("\\s+");
                    replacementMap.put(object[0], object[1]);
                }
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        } else {
            replacementMap = null;
        }
    }

    public static void setResourceFinder(ResourceFinder resourceFinder) {
        IteratorFactory.resourceFinder = resourceFinder;
    }

    public static Iterator<String> tokenize(BufferedReader bufferedReader) {
        return IteratorFactory.getBaseIterator(bufferedReader, false);
    }

    public static Iterator<String> tokenize(String string) {
        return IteratorFactory.tokenize(new BufferedReader(new StringReader(string)));
    }

    public static Iterator<String> tokenizeOrdered(BufferedReader bufferedReader) {
        return IteratorFactory.getBaseIterator(bufferedReader, true);
    }

    public static Iterator<String> tokenizeOrdered(String string) {
        return IteratorFactory.tokenizeOrdered(new BufferedReader(new StringReader(string)));
    }

    public static Iterator<String> tokenizeOrderedWithReplacement(BufferedReader bufferedReader) {
        WordReplacementIterator wordReplacementIterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        return replacementMap == null ? wordReplacementIterator : new WordReplacementIterator(wordReplacementIterator, replacementMap);
    }

    private static Iterator<String> getBaseIterator(BufferedReader bufferedReader, boolean bl) {
        Iterator<String> iterator = new WordIterator(bufferedReader);
        if (replacementMap != null) {
            iterator = new WordReplacementIterator(iterator, replacementMap);
        }
        if (compoundTokens != null) {
            CompoundWordIterator compoundWordIterator = compoundIterators.get(Thread.currentThread());
            if (compoundWordIterator == null) {
                compoundWordIterator = new CompoundWordIterator(iterator, compoundTokens);
                compoundIterators.put(Thread.currentThread(), compoundWordIterator);
            } else {
                compoundWordIterator.reset(iterator);
            }
            iterator = compoundWordIterator;
        }
        if (wordLimit > 0) {
            iterator = new LimitedIterator<String>(iterator, wordLimit);
        }
        if (filter != null) {
            Iterator<String> iterator2 = iterator = bl ? new OrderPreservingFilteredIterator(iterator, filter) : new FilteredIterator(iterator, filter);
        }
        if (stemmer != null) {
            iterator = new StemmingIterator(iterator, stemmer);
        }
        return iterator;
    }

    static {
        ITERATOR_FACTORY_PROPERTIES.add(TOKEN_FILTER_PROPERTY);
        ITERATOR_FACTORY_PROPERTIES.add(STEMMER_PROPERTY);
        ITERATOR_FACTORY_PROPERTIES.add(COMPOUND_TOKENS_FILE_PROPERTY);
        ITERATOR_FACTORY_PROPERTIES.add(TOKEN_REPLACEMENT_FILE_PROPERTY);
        ITERATOR_FACTORY_PROPERTIES.add(TOKEN_COUNT_LIMIT_PROPERTY);
        resourceFinder = new FileResourceFinder();
        compoundIterators = new HashMap<Thread, CompoundWordIterator>();
        compoundTokens = null;
    }
}

