/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.text.TemporalDocument;
import edu.ucla.sspace.text.TemporalFileDocument;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FileListTemporalDocumentIterator
implements Iterator<TemporalDocument> {
    private final Queue<NameAndTime> filesToProcess = new ConcurrentLinkedQueue<NameAndTime>();

    public FileListTemporalDocumentIterator(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.length() == 0 || string2.startsWith("#")) continue;
            String[] stringArray = string2.split("\\s+");
            String string3 = stringArray[0];
            long l = stringArray.length > 1 ? Long.parseLong(stringArray[1]) : -1L;
            this.filesToProcess.offer(new NameAndTime(string3, l));
        }
        bufferedReader.close();
    }

    @Override
    public boolean hasNext() {
        return !this.filesToProcess.isEmpty();
    }

    @Override
    public TemporalDocument next() {
        NameAndTime nameAndTime = this.filesToProcess.poll();
        if (nameAndTime == null) {
            return null;
        }
        try {
            return nameAndTime.hasTimeStamp() ? new TemporalFileDocument(nameAndTime.fileName, nameAndTime.timeStamp) : new TemporalFileDocument(nameAndTime.fileName);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("removing documents is not supported");
    }

    private static class NameAndTime {
        public final String fileName;
        public final long timeStamp;

        public NameAndTime(String string, long l) {
            this.fileName = string;
            this.timeStamp = l;
        }

        public boolean hasTimeStamp() {
            return this.timeStamp >= 0L;
        }
    }
}

