/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.text.BufferedIterator;
import edu.ucla.sspace.util.Duple;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CompoundWordIterator
implements Iterator<String> {
    private final Map<String, CompoundTokens> compoundTokens;
    private BufferedIterator tokenizer;

    public CompoundWordIterator(String string, Set<String> set) {
        this(new BufferedReader(new StringReader(string)), set);
    }

    public CompoundWordIterator(BufferedReader bufferedReader, Set<String> set) {
        this.tokenizer = new BufferedIterator(bufferedReader);
        this.compoundTokens = new LinkedHashMap<String, CompoundTokens>();
        this.initializeMapping(set);
    }

    public CompoundWordIterator(Iterator<String> iterator, Set<String> set) {
        this.tokenizer = new BufferedIterator(iterator);
        this.compoundTokens = new LinkedHashMap<String, CompoundTokens>();
        this.initializeMapping(set);
    }

    private void initializeMapping(Set<String> set) {
        for (String string : set) {
            String[] stringArray = string.split("\\s+");
            if (stringArray.length == 1) continue;
            CompoundTokens compoundTokens = this.compoundTokens.get(stringArray[0]);
            if (compoundTokens == null) {
                compoundTokens = new CompoundTokens();
                this.compoundTokens.put(stringArray[0], compoundTokens);
            }
            List<String> list = Arrays.asList(Arrays.copyOfRange(stringArray, 1, stringArray.length));
            compoundTokens.addCompound(list, string);
        }
    }

    @Override
    public boolean hasNext() {
        return this.tokenizer.hasNext();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.tokenizer.next();
        CompoundTokens compoundTokens = this.compoundTokens.get(string);
        if (compoundTokens != null) {
            List<String> list = this.tokenizer.peek(compoundTokens.maxTokens());
            Duple<Integer, String> duple = compoundTokens.findMatch(list);
            if (duple != null) {
                for (int i = 0; i < (Integer)duple.x; ++i) {
                    this.tokenizer.next();
                }
                return (String)duple.y;
            }
            return string;
        }
        return string;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    public void reset(BufferedReader bufferedReader) {
        this.tokenizer = new BufferedIterator(bufferedReader);
    }

    public void reset(Iterator<String> iterator) {
        this.tokenizer = new BufferedIterator(iterator);
    }

    private static class CompoundTokens {
        private final Map<List<String>, String> compounds = new LinkedHashMap<List<String>, String>();
        private int maxTokens = 0;

        public void addCompound(List<String> list, String string) {
            this.compounds.put(list, string);
            if (list.size() > this.maxTokens) {
                this.maxTokens = list.size();
            }
        }

        public int maxTokens() {
            return this.maxTokens;
        }

        public Duple<Integer, String> findMatch(List<String> list) {
            String string = null;
            int n = -1;
            for (Map.Entry<List<String>, String> entry : this.compounds.entrySet()) {
                if (!((Object)entry.getKey()).equals(list) || string != null && string.length() >= entry.getValue().length()) continue;
                string = entry.getValue();
                n = entry.getKey().size();
            }
            return string == null ? null : new Duple<Integer, Object>(n, string);
        }
    }
}

