/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.nonlinear;

import edu.ucla.sspace.basis.StringBasisMapping;
import edu.ucla.sspace.common.GenericTermDocumentVectorSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.AffinityMatrixCreator;
import edu.ucla.sspace.matrix.LocalityPreservingProjection;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SvdlibcSparseBinaryMatrixBuilder;
import edu.ucla.sspace.matrix.Transform;
import edu.ucla.sspace.util.LoggerUtil;
import edu.ucla.sspace.util.ReflectionUtil;
import java.io.IOError;
import java.io.IOException;
import java.util.Properties;

public class LocalityPreservingSemanticAnalysis
extends GenericTermDocumentVectorSpace {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis";
    public static final String MATRIX_TRANSFORM_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis.transform";
    public static final String LPSA_DIMENSIONS_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis.dimensions";
    public static final String LPSA_AFFINITY_EDGE_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis.affinityEdgeType";
    public static final String LPSA_AFFINITY_EDGE_PARAM_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis.affinityEdgeTypeParam";
    public static final String LPSA_AFFINITY_EDGE_WEIGHTING_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis.affinityEdgeWeighting";
    public static final String LPSA_AFFINITY_EDGE_WEIGHTING_PARAM_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis.affinityEdgeWeightingParam";
    private static final String LPSA_SSPACE_NAME = "lpsa-semantic-space";

    public LocalityPreservingSemanticAnalysis() throws IOException {
        super(false, new StringBasisMapping(), new SvdlibcSparseBinaryMatrixBuilder(true));
    }

    @Override
    public String getSpaceName() {
        return LPSA_SSPACE_NAME;
    }

    @Override
    public void processSpace(Properties properties) {
        try {
            String string;
            String string2;
            String string3;
            String string4;
            Transform transform = null;
            String string5 = properties.getProperty(MATRIX_TRANSFORM_PROPERTY);
            if (string5 != null) {
                transform = (Transform)ReflectionUtil.getObjectInstance(string5);
            }
            MatrixFile matrixFile = this.processSpace(transform);
            int n = 300;
            AffinityMatrixCreator.EdgeType edgeType = AffinityMatrixCreator.EdgeType.NEAREST_NEIGHBORS;
            double d = 20.0;
            AffinityMatrixCreator.EdgeWeighting edgeWeighting = AffinityMatrixCreator.EdgeWeighting.COSINE_SIMILARITY;
            double d2 = 0.0;
            String string6 = properties.getProperty(LPSA_DIMENSIONS_PROPERTY);
            if (string6 != null) {
                try {
                    n = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis.dimensions is not an integer: " + string6);
                }
            }
            if ((string4 = properties.getProperty(LPSA_AFFINITY_EDGE_PROPERTY)) != null) {
                edgeType = AffinityMatrixCreator.EdgeType.valueOf(string4.toUpperCase());
            }
            if ((string3 = properties.getProperty(LPSA_AFFINITY_EDGE_PARAM_PROPERTY)) != null) {
                try {
                    d = Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis.affinityEdgeTypeParam is not an double: " + string3);
                }
            }
            if ((string2 = properties.getProperty(LPSA_AFFINITY_EDGE_WEIGHTING_PROPERTY)) != null) {
                edgeWeighting = AffinityMatrixCreator.EdgeWeighting.valueOf(string2.toUpperCase());
            }
            if ((string = properties.getProperty(LPSA_AFFINITY_EDGE_WEIGHTING_PARAM_PROPERTY)) != null) {
                try {
                    d2 = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("edu.ucla.sspace.lpsa.LocalityPreservingSemanticAnalysis.affinityEdgeWeightingParam is not an double: " + string);
                }
            }
            LoggerUtil.verbose(LOG, "reducing to %d dimensions", n);
            Matrix matrix = MatrixIO.readMatrix(matrixFile.getFile(), matrixFile.getFormat(), Matrix.Type.SPARSE_IN_MEMORY, true);
            MatrixFile matrixFile2 = AffinityMatrixCreator.calculate(matrix, Similarity.SimType.COSINE, edgeType, d, edgeWeighting, d2);
            this.wordSpace = LocalityPreservingProjection.project(matrix, matrixFile2, n);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }
}

