/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import edu.ucla.sspace.vector.Vectors;
import java.io.Serializable;

public class YaleSparseMatrix
implements SparseMatrix,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int rows;
    private final int cols;
    private final CompactSparseVector[] sparseMatrix;

    public YaleSparseMatrix(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.sparseMatrix = new CompactSparseVector[n];
        for (int i = 0; i < n; ++i) {
            this.sparseMatrix[i] = new CompactSparseVector(n2);
        }
    }

    public YaleSparseMatrix(double[][] dArray) {
        this.rows = dArray.length;
        this.cols = dArray[0].length;
        this.sparseMatrix = new CompactSparseVector[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.sparseMatrix[i] = new CompactSparseVector(this.cols);
            for (int j = 0; j < this.cols; ++j) {
                if (dArray[i][j] == 0.0) continue;
                this.sparseMatrix[i].set(j, dArray[i][j]);
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.rows || n2 >= this.cols) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public double get(int n, int n2) {
        this.checkIndices(n, n2);
        return this.sparseMatrix[n].get(n2);
    }

    @Override
    public double[] getColumn(int n) {
        double[] dArray = new double[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            dArray[i] = this.get(i, n);
        }
        return dArray;
    }

    @Override
    public SparseDoubleVector getColumnVector(int n) {
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            sparseHashDoubleVector.set(i, this.get(i, n));
        }
        return sparseHashDoubleVector;
    }

    @Override
    public double[] getRow(int n) {
        return this.sparseMatrix[n].toArray();
    }

    @Override
    public SparseDoubleVector getRowVector(int n) {
        return Vectors.immutable(this.sparseMatrix[n]);
    }

    @Override
    public int columns() {
        return this.cols;
    }

    @Override
    public void set(int n, int n2, double d) {
        this.checkIndices(n, n2);
        this.sparseMatrix[n].set(n2, d);
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("invalid number of rows: " + dArray.length);
        }
        for (int i = 0; i < this.rows; ++i) {
            this.set(i, n, dArray[i]);
        }
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        if (doubleVector.length() != this.rows) {
            throw new IllegalArgumentException("invalid number of rows: " + doubleVector.length());
        }
        for (int i = 0; i < this.rows; ++i) {
            this.set(i, n, doubleVector.get(i));
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        if (dArray.length != this.cols) {
            throw new IllegalArgumentException("invalid number of columns: " + dArray.length);
        }
        for (int i = 0; i < this.cols; ++i) {
            this.sparseMatrix[n].set(i, dArray[i]);
        }
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        if (doubleVector.length() != this.cols) {
            throw new IllegalArgumentException("invalid number of columns: " + doubleVector.length());
        }
        Vectors.copy(this.sparseMatrix[n], doubleVector);
    }

    @Override
    public double[][] toDenseArray() {
        double[][] dArray = new double[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            dArray[i] = this.sparseMatrix[i].toArray();
        }
        return dArray;
    }

    @Override
    public int rows() {
        return this.rows;
    }
}

