/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.AbstractMatrix;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import java.io.Serializable;

public class SymmetricMatrix
extends AbstractMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Matrix backing;

    public SymmetricMatrix(Matrix matrix) {
        this.backing = matrix;
    }

    @Override
    public int columns() {
        return this.backing.columns();
    }

    @Override
    public double get(int n, int n2) {
        if (n > n2) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        return this.backing.get(n, n2);
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        int n2 = this.rows();
        DenseVector denseVector = new DenseVector(n2);
        for (int i = 0; i < n2; ++i) {
            denseVector.set(i, this.get(i, n));
        }
        return denseVector;
    }

    @Override
    public DoubleVector getRowVector(int n) {
        int n2 = this.columns();
        DenseVector denseVector = new DenseVector(n2);
        for (int i = 0; i < n2; ++i) {
            denseVector.set(i, this.get(n, i));
        }
        return denseVector;
    }

    @Override
    public int rows() {
        return this.backing.rows();
    }

    @Override
    public void set(int n, int n2, double d) {
        if (n > n2) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        this.backing.set(n, n2, d);
    }
}

