/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.OnDiskMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SparseOnDiskMatrix
extends OnDiskMatrix
implements SparseMatrix {
    private final Map<Integer, VersionedVector> rowToVectorCache;
    private final Map<Integer, VersionedVector> colToVectorCache;
    private final AtomicInteger version = new AtomicInteger(0);

    public SparseOnDiskMatrix(int n, int n2) {
        super(n, n2);
        this.rowToVectorCache = new WeakHashMap<Integer, VersionedVector>();
        this.colToVectorCache = new WeakHashMap<Integer, VersionedVector>();
    }

    @Override
    public SparseDoubleVector getColumnVector(int n) {
        VersionedVector versionedVector = this.colToVectorCache.get(n);
        if (versionedVector == null || versionedVector.version != this.version.get()) {
            versionedVector = new VersionedVector(this.rows(), this.version.get());
            double[] dArray = this.getColumn(n);
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                if (d == 0.0) continue;
                versionedVector.set(i, d);
            }
            this.colToVectorCache.put(n, versionedVector);
        }
        return versionedVector;
    }

    @Override
    public SparseDoubleVector getRowVector(int n) {
        VersionedVector versionedVector = this.colToVectorCache.get(n);
        if (versionedVector == null || versionedVector.version != this.version.get()) {
            versionedVector = new VersionedVector(this.columns(), this.version.get());
            double[] dArray = this.getRow(n);
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                if (d == 0.0) continue;
                versionedVector.set(i, d);
            }
            this.rowToVectorCache.put(n, versionedVector);
        }
        return versionedVector;
    }

    @Override
    public void set(int n, int n2, double d) {
        super.set(n, n2, d);
        this.version.incrementAndGet();
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        super.setColumn(n, dArray);
        this.version.incrementAndGet();
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        super.setColumn(n, doubleVector);
        this.version.incrementAndGet();
    }

    @Override
    public void setRow(int n, double[] dArray) {
        super.setRow(n, dArray);
        this.version.incrementAndGet();
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        super.setRow(n, doubleVector);
        this.version.incrementAndGet();
    }

    private static class VersionedVector
    extends SparseHashDoubleVector {
        private static final long serialVersionUID = 1L;
        private final int version;

        public VersionedVector(int n, int n2) {
            super(n);
            this.version = n2;
        }
    }
}

