/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class RowMaskedMatrix
implements Matrix {
    private final Matrix backingMatrix;
    private final int rows;
    private final int[] rowToReal;

    public RowMaskedMatrix(Matrix matrix, BitSet bitSet) {
        this.backingMatrix = matrix;
        this.rowToReal = new int[bitSet.cardinality()];
        int n = bitSet.nextSetBit(0);
        int n2 = 0;
        while (n >= 0) {
            if (n >= matrix.rows()) {
                throw new IllegalArgumentException("specified row not present in original matrix: " + n);
            }
            this.rowToReal[n2] = n;
            n = bitSet.nextSetBit(n + 1);
            ++n2;
        }
        this.rows = this.rowToReal.length;
    }

    public RowMaskedMatrix(Matrix matrix, Set<Integer> set) {
        this.backingMatrix = matrix;
        this.rowToReal = new int[set.size()];
        int[] nArray = new int[set.size()];
        int n = 0;
        for (Integer n2 : set) {
            if (n2 < 0 || n2 >= matrix.rows()) {
                throw new IllegalArgumentException("Cannot specify a row outside the original matrix dimensions:" + n2);
            }
            this.rowToReal[n++] = n2;
        }
        Arrays.sort(this.rowToReal);
        this.rows = this.rowToReal.length;
    }

    public RowMaskedMatrix(Matrix matrix, LinkedHashSet<Integer> linkedHashSet) {
        this.backingMatrix = matrix;
        this.rowToReal = new int[linkedHashSet.size()];
        int n = 0;
        for (Integer n2 : linkedHashSet) {
            if (n2 < 0 || n2 >= matrix.rows()) {
                throw new IllegalArgumentException("Cannot specify a row outside the original matrix dimensions:" + n2);
            }
            this.rowToReal[n++] = n2;
        }
        this.rows = this.rowToReal.length;
    }

    public RowMaskedMatrix(Matrix matrix, int[] nArray) {
        this.rowToReal = new int[nArray.length];
        this.rows = nArray.length;
        if (matrix instanceof RowMaskedMatrix) {
            RowMaskedMatrix rowMaskedMatrix = (RowMaskedMatrix)matrix;
            this.backingMatrix = rowMaskedMatrix.backingMatrix;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < 0 || n >= matrix.rows()) {
                    throw new IllegalArgumentException("Cannot specify a row outside the original matrix dimensions:" + n);
                }
                this.rowToReal[i] = rowMaskedMatrix.rowToReal[n];
            }
        } else {
            this.backingMatrix = matrix;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < 0 || n >= matrix.rows()) {
                    throw new IllegalArgumentException("Cannot specify a row outside the original matrix dimensions:" + n);
                }
                this.rowToReal[i] = n;
            }
        }
    }

    protected int getRealRow(int n) {
        if (n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row out of bounds: " + n);
        }
        return this.rowToReal[n];
    }

    @Override
    public double get(int n, int n2) {
        return this.backingMatrix.get(this.getRealRow(n), n2);
    }

    @Override
    public double[] getColumn(int n) {
        double[] dArray = new double[this.rows];
        for (int i = 0; i < this.rowToReal.length; ++i) {
            dArray[i] = this.backingMatrix.get(this.rowToReal[i], n);
        }
        return dArray;
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        return new DenseVector(this.getColumn(n));
    }

    @Override
    public double[] getRow(int n) {
        return this.backingMatrix.getRow(this.getRealRow(n));
    }

    @Override
    public DoubleVector getRowVector(int n) {
        return this.backingMatrix.getRowVector(this.getRealRow(n));
    }

    @Override
    public int columns() {
        return this.backingMatrix.columns();
    }

    @Override
    public double[][] toDenseArray() {
        double[][] dArray = new double[this.rows][this.backingMatrix.columns()];
        for (int i = 0; i < this.rowToReal.length; ++i) {
            dArray[i] = this.backingMatrix.getRow(this.rowToReal[i]);
        }
        return dArray;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public void set(int n, int n2, double d) {
        this.backingMatrix.set(this.getRealRow(n), n2, d);
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("cannot set a column whose dimensions are different than the matrix");
        }
        for (int i = 0; i < this.rowToReal.length; ++i) {
            this.backingMatrix.set(this.rowToReal[i], n, dArray[i]);
        }
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        if (doubleVector.length() != this.rows) {
            throw new IllegalArgumentException("cannot set a column whose dimensions are different than the matrix");
        }
        if (doubleVector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)doubleVector);
            for (int n2 : sparseVector.getNonZeroIndices()) {
                this.backingMatrix.set(this.getRealRow(n2), n2, doubleVector.get(n2));
            }
        } else {
            for (int i = 0; i < this.rowToReal.length; ++i) {
                this.backingMatrix.set(this.rowToReal[i], i, doubleVector.get(i));
            }
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        this.backingMatrix.setRow(this.getRealRow(n), dArray);
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        this.backingMatrix.setRow(this.getRealRow(n), doubleVector);
    }

    public Matrix backingMatrix() {
        return this.backingMatrix;
    }

    public int[] reordering() {
        return this.rowToReal;
    }
}

