/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;

public class Normalize {
    private Normalize() {
    }

    public static void byRow(Matrix matrix) {
        for (int i = 0; i < matrix.rows(); ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < matrix.columns(); ++n) {
                d += matrix.get(i, n);
            }
            if (d == 0.0) continue;
            for (n = 0; n < matrix.columns(); ++n) {
                matrix.set(i, n, matrix.get(i, n) / d);
            }
        }
    }

    public static void byColumn(Matrix matrix) {
        for (int i = 0; i < matrix.columns(); ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < matrix.rows(); ++n) {
                d += matrix.get(n, i);
            }
            if (d == 0.0) continue;
            for (n = 0; n < matrix.rows(); ++n) {
                matrix.set(n, i, matrix.get(n, i) / d);
            }
        }
    }

    public static void byLength(Matrix matrix) {
        for (int i = 0; i < matrix.rows(); ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < matrix.columns(); ++n) {
                d += Math.pow(matrix.get(i, n), 2.0);
            }
            if ((d = Math.sqrt(d)) == 0.0) continue;
            for (n = 0; n < matrix.columns(); ++n) {
                matrix.set(i, n, matrix.get(i, n) / d);
            }
        }
    }

    public static void byMagnitude(Matrix matrix) {
        int n;
        int n2;
        double d = 0.0;
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            for (n = 0; n < matrix.columns(); ++n) {
                d += Math.pow(matrix.get(n2, n), 2.0);
            }
        }
        if ((d = Math.sqrt(d)) == 0.0) {
            return;
        }
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            for (n = 0; n < matrix.columns(); ++n) {
                matrix.set(n2, n, matrix.get(n2, n) / d);
            }
        }
    }

    public static void byCorrelation(Matrix matrix, boolean bl) {
        int n;
        int n2;
        double d = 0.0;
        double[] dArray = new double[matrix.rows()];
        double[] dArray2 = new double[matrix.columns()];
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            for (n = 0; n < matrix.columns(); ++n) {
                d += matrix.get(n2, n);
                int n3 = n;
                dArray2[n3] = dArray2[n3] + matrix.get(n2, n);
                int n4 = n2;
                dArray[n4] = dArray[n4] + matrix.get(n2, n);
            }
        }
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            for (n = 0; n < matrix.columns(); ++n) {
                double d2 = (d * matrix.get(n2, n) - dArray[n2] * dArray2[n]) / Math.sqrt(dArray[n2] * (d - dArray[n2]) * dArray2[n] * (d - dArray2[n]));
                if (bl) {
                    matrix.set(n2, n, d2);
                    continue;
                }
                matrix.set(n2, n, d2 > 0.0 ? d2 : 0.0);
            }
        }
    }
}

