/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.ArrayMatrix;
import edu.ucla.sspace.matrix.AtomicMatrix;
import edu.ucla.sspace.matrix.DiagonalMatrix;
import edu.ucla.sspace.matrix.ListMatrix;
import edu.ucla.sspace.matrix.MatlabSparseMatrixBuilder;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixBuilder;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.OnDiskMatrix;
import edu.ucla.sspace.matrix.SVD;
import edu.ucla.sspace.matrix.SparseListMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.matrix.SvdlibcSparseBinaryMatrixBuilder;
import edu.ucla.sspace.matrix.SynchronizedMatrix;
import edu.ucla.sspace.matrix.SynchronizedSparseMatrix;
import edu.ucla.sspace.matrix.TransposedMatrix;
import edu.ucla.sspace.matrix.YaleSparseMatrix;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.util.List;
import java.util.logging.Logger;

public class Matrices {
    private static final Logger LOGGER = Logger.getLogger(Matrices.class.getName());
    private static final int BYTES_PER_DOUBLE = 8;
    private static final double SPARSE_DENSITY = 1.0E-5;

    private Matrices() {
    }

    public static <T extends DoubleVector> Matrix asMatrix(List<T> list) {
        return new ListMatrix<T>(list);
    }

    public static <T extends SparseDoubleVector> SparseMatrix asSparseMatrix(List<T> list) {
        return new SparseListMatrix<T>(list);
    }

    public static <T extends SparseDoubleVector> SparseMatrix asSparseMatrix(List<T> list, int n) {
        return new SparseListMatrix<T>(list, n);
    }

    public static Matrix create(int n, int n2, boolean bl) {
        Runtime runtime;
        long l;
        long l2 = bl ? (long)n * (long)n2 * 8L : (long)((double)((long)n * (long)n2) * 8.0E-5);
        if (l2 < (l = (runtime = Runtime.getRuntime()).freeMemory())) {
            if (bl) {
                if (l2 > Integer.MAX_VALUE) {
                    LOGGER.finer("too big for ArrayMatrix; creating new OnDiskMatrix");
                    return new OnDiskMatrix(n, n2);
                }
                LOGGER.finer("creating new (in memory) ArrayMatrix");
                return new ArrayMatrix(n, n2);
            }
            LOGGER.finer("can fit sparse in memory; creating new SparseMatrix");
            return new YaleSparseMatrix(n, n2);
        }
        LOGGER.finer("cannot fit in memory; creating new OnDiskMatrix");
        return new OnDiskMatrix(n, n2);
    }

    public static Matrix copy(Matrix matrix) {
        Matrix matrix2 = null;
        matrix2 = matrix instanceof SparseMatrix ? Matrices.create(matrix.rows(), matrix.columns(), Matrix.Type.SPARSE_IN_MEMORY) : Matrices.create(matrix.rows(), matrix.columns(), Matrix.Type.DENSE_IN_MEMORY);
        return Matrices.copyTo(matrix, matrix2);
    }

    public static Matrix copyTo(Matrix matrix, Matrix matrix2) {
        if (matrix.rows() != matrix2.rows() || matrix.columns() != matrix2.columns()) {
            throw new IllegalArgumentException("Matrix dimensions must match when copying.");
        }
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            for (int i = 0; i < matrix.rows(); ++i) {
                SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(i);
                for (int n : sparseDoubleVector.getNonZeroIndices()) {
                    matrix2.set(i, n, sparseDoubleVector.get(n));
                }
            }
        } else {
            for (int i = 0; i < matrix.rows(); ++i) {
                for (int j = 0; j < matrix.columns(); ++j) {
                    matrix2.set(i, j, matrix.get(i, j));
                }
            }
        }
        return matrix2;
    }

    public static Matrix create(int n, int n2, Matrix.Type type) {
        switch (type) {
            case SPARSE_IN_MEMORY: {
                return new YaleSparseMatrix(n, n2);
            }
            case DENSE_IN_MEMORY: {
                return new ArrayMatrix(n, n2);
            }
            case DIAGONAL_IN_MEMORY: {
                return new DiagonalMatrix(n);
            }
            case SPARSE_ON_DISK: {
                return new OnDiskMatrix(n, n2);
            }
            case DENSE_ON_DISK: {
                return new OnDiskMatrix(n, n2);
            }
        }
        throw new IllegalArgumentException("Unknown matrix type: " + (Object)((Object)type));
    }

    public static MatrixBuilder getMatrixBuilderForSVD() {
        return Matrices.getMatrixBuilderForSVD(false);
    }

    public static MatrixBuilder getMatrixBuilderForSVD(boolean bl) {
        SVD.Algorithm algorithm = SVD.getFastestAvailableAlgorithm();
        if (algorithm == null) {
            LOGGER.warning("no SVD support detected.  Returning default matrix builder instead");
            return new MatlabSparseMatrixBuilder(bl);
        }
        switch (algorithm) {
            case SVDLIBC: {
                return new SvdlibcSparseBinaryMatrixBuilder(bl);
            }
        }
        return new MatlabSparseMatrixBuilder(bl);
    }

    static boolean isDense(MatrixIO.Format format) {
        switch (format) {
            case DENSE_TEXT: 
            case SVDLIBC_DENSE_TEXT: 
            case SVDLIBC_DENSE_BINARY: {
                return true;
            }
            case MATLAB_SPARSE: 
            case SVDLIBC_SPARSE_TEXT: 
            case SVDLIBC_SPARSE_BINARY: {
                return false;
            }
        }
        assert (false) : format;
        return true;
    }

    private static Matrix multiplyRightDiag(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = Matrices.create(matrix.rows(), matrix2.columns(), true);
        for (int i = 0; i < matrix.rows(); ++i) {
            double[] dArray = matrix.getRow(i);
            for (int j = 0; j < matrix2.columns(); ++j) {
                double d = matrix2.get(j, j);
                matrix3.set(i, j, d * dArray[j]);
            }
        }
        return matrix3;
    }

    private static Matrix multiplyBothDiag(Matrix matrix, Matrix matrix2) {
        DiagonalMatrix diagonalMatrix = new DiagonalMatrix(matrix.rows());
        for (int i = 0; i < matrix.rows(); ++i) {
            diagonalMatrix.set(i, i, matrix.get(i, i) * matrix2.get(i, i));
        }
        return diagonalMatrix;
    }

    private static Matrix multiplyLeftDiag(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = Matrices.create(matrix.rows(), matrix2.columns(), true);
        for (int i = 0; i < matrix.rows(); ++i) {
            double d = matrix.get(i, i);
            double[] dArray = matrix2.getRow(i);
            for (int j = 0; j < matrix2.columns(); ++j) {
                matrix3.set(i, j, d * dArray[j]);
            }
        }
        return matrix3;
    }

    public static Matrix multiply(Matrix matrix, Matrix matrix2) {
        if (matrix.columns() != matrix2.rows()) {
            throw new IllegalArgumentException("The number of columns in the first matrix do not match the number of rows in the second matrix.");
        }
        if (matrix.columns() != matrix2.rows()) {
            return null;
        }
        if (matrix2 instanceof DiagonalMatrix) {
            if (matrix instanceof DiagonalMatrix) {
                return Matrices.multiplyBothDiag(matrix, matrix2);
            }
            return Matrices.multiplyRightDiag(matrix, matrix2);
        }
        if (matrix instanceof DiagonalMatrix) {
            return Matrices.multiplyLeftDiag(matrix, matrix2);
        }
        if (matrix2 instanceof DiagonalMatrix) {
            if (matrix instanceof DiagonalMatrix) {
                return Matrices.multiplyBothDiag(matrix, matrix2);
            }
            return Matrices.multiplyRightDiag(matrix, matrix2);
        }
        if (matrix instanceof DiagonalMatrix) {
            return Matrices.multiplyLeftDiag(matrix, matrix2);
        }
        int n = matrix.columns();
        Matrix matrix3 = Matrices.create(matrix.rows(), matrix2.columns(), true);
        for (int i = 0; i < matrix.rows(); ++i) {
            double[] dArray = matrix.getRow(i);
            for (int j = 0; j < matrix2.columns(); ++j) {
                double d = 0.0;
                for (int k = 0; k < dArray.length; ++k) {
                    d += dArray[k] * matrix2.get(k, j);
                }
                matrix3.set(i, j, d);
            }
        }
        return matrix3;
    }

    public static Matrix resize(Matrix matrix, int n, int n2) {
        boolean bl = !(matrix instanceof SparseMatrix) && !(matrix instanceof DiagonalMatrix);
        Matrix matrix2 = Matrices.create(n, n2, bl);
        int n3 = Math.min(n, matrix.rows());
        int n4 = Math.min(n2, matrix.columns());
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                matrix2.set(i, j, matrix.get(i, j));
            }
        }
        return matrix2;
    }

    public static AtomicMatrix synchronizedMatrix(Matrix matrix) {
        return new SynchronizedMatrix(matrix);
    }

    public static AtomicMatrix synchronizedSparseMatrix(SparseMatrix sparseMatrix) {
        return new SynchronizedSparseMatrix(sparseMatrix);
    }

    public static Matrix transpose(Matrix matrix) {
        return matrix instanceof TransposedMatrix ? ((TransposedMatrix)matrix).m : new TransposedMatrix(matrix);
    }
}

