/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.ClutoSparseMatrixBuilder;
import edu.ucla.sspace.matrix.MatrixBuilder;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.util.SparseArray;
import edu.ucla.sspace.vector.Vector;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.logging.Logger;

public class ClutoDenseMatrixBuilder
implements MatrixBuilder {
    private static final Logger LOGGER = Logger.getLogger(ClutoSparseMatrixBuilder.class.getName());
    private final File matrixFile;
    private final PrintWriter writer;
    private boolean isFinished;
    private int curRow;
    private int numCols;

    public ClutoDenseMatrixBuilder() {
        this(ClutoDenseMatrixBuilder.getTempMatrixFile());
    }

    public ClutoDenseMatrixBuilder(File file) {
        this.matrixFile = file;
        this.curRow = 0;
        this.numCols = 0;
        this.isFinished = false;
        try {
            this.writer = new PrintWriter(file);
            char[] cArray = new char[100];
            Arrays.fill(cArray, ' ');
            this.writer.println(cArray);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private static File getTempMatrixFile() {
        File file = null;
        try {
            file = File.createTempFile("cluto-dense-matrix", ".dat");
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return file;
    }

    @Override
    public synchronized int addColumn(double[] dArray) {
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        if (dArray.length > this.numCols) {
            this.numCols = dArray.length;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append(dArray[i]).append(" ");
        }
        this.writer.println(stringBuilder.toString());
        return ++this.curRow;
    }

    @Override
    public synchronized int addColumn(SparseArray<? extends Number> sparseArray) {
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        if (sparseArray.length() > this.numCols) {
            this.numCols = sparseArray.length();
        }
        assert (sparseArray.length() != Integer.MAX_VALUE) : "adding a column whose length is Integer.MAX_VALUE (was likley left unspecified in the  constructor).";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < sparseArray.length(); ++i) {
            stringBuilder.append(sparseArray.get(i).floatValue()).append(" ");
        }
        this.writer.println(stringBuilder.toString());
        return ++this.curRow;
    }

    @Override
    public synchronized int addColumn(Vector vector) {
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        if (vector.length() > this.numCols) {
            this.numCols = vector.length();
        }
        assert (vector.length() != Integer.MAX_VALUE) : "adding a column whose length is Integer.MAX_VALUE (was likley left unspecified in the  constructor).";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < vector.length(); ++i) {
            stringBuilder.append(vector.getValue(i).doubleValue()).append(" ");
        }
        this.writer.println(stringBuilder.toString());
        return ++this.curRow;
    }

    @Override
    public synchronized void finish() {
        if (!this.isFinished) {
            this.isFinished = true;
            try {
                this.writer.flush();
                this.writer.close();
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.matrixFile, "rw");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.curRow).append(" ");
                stringBuilder.append(this.numCols).append(" ");
                randomAccessFile.write(stringBuilder.toString().getBytes());
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }
    }

    @Override
    public synchronized File getFile() {
        if (!this.isFinished) {
            throw new IllegalStateException("Cannot access matrix file until finished has been called");
        }
        return this.matrixFile;
    }

    @Override
    public MatrixIO.Format getMatrixFormat() {
        return MatrixIO.Format.CLUTO_DENSE;
    }

    @Override
    public MatrixFile getMatrixFile() {
        return new MatrixFile(this.getFile(), this.getMatrixFormat());
    }

    @Override
    public synchronized boolean isFinished() {
        return this.isFinished;
    }
}

