/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.MaskedDoubleVectorView;
import java.util.HashSet;
import java.util.Set;

public class CellMaskedMatrix
implements Matrix {
    protected final int[] rowMaskMap;
    protected final int[] colMaskMap;
    private final Matrix matrix;

    public CellMaskedMatrix(Matrix matrix, int[] nArray, int[] nArray2) {
        this.matrix = matrix;
        this.rowMaskMap = nArray;
        this.colMaskMap = nArray2;
        assert (this.arrayToSet(nArray).size() == nArray.length) : "input mapping contains duplicates mappings to the same row";
        assert (this.arrayToSet(nArray2).size() == nArray2.length) : "input mapping contains duplicates mappings to the same column";
    }

    private Set<Integer> arrayToSet(int[] nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : nArray) {
            hashSet.add(n);
        }
        return hashSet;
    }

    protected int getIndexFromMap(int[] nArray, int n) {
        if (n < 0 || n >= nArray.length) {
            throw new IndexOutOfBoundsException("The given index is beyond the bounds of the matrix");
        }
        int n2 = nArray[n];
        if (n2 < 0 || nArray == this.rowMaskMap && n2 >= this.matrix.rows() || nArray == this.colMaskMap && n2 >= this.matrix.columns()) {
            throw new IndexOutOfBoundsException("The mapped index is beyond the bounds of the base matrix");
        }
        return n2;
    }

    @Override
    public double get(int n, int n2) {
        n = this.getIndexFromMap(this.rowMaskMap, n);
        n2 = this.getIndexFromMap(this.colMaskMap, n2);
        return this.matrix.get(n, n2);
    }

    @Override
    public double[] getColumn(int n) {
        n = this.getIndexFromMap(this.colMaskMap, n);
        double[] dArray = new double[this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            dArray[i] = this.matrix.get(this.getIndexFromMap(this.rowMaskMap, i), n);
        }
        return dArray;
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        n = this.getIndexFromMap(this.colMaskMap, n);
        DoubleVector doubleVector = this.matrix.getColumnVector(n);
        return new MaskedDoubleVectorView(doubleVector, this.rowMaskMap);
    }

    @Override
    public double[] getRow(int n) {
        n = this.getIndexFromMap(this.rowMaskMap, n);
        double[] dArray = new double[this.columns()];
        for (int i = 0; i < this.columns(); ++i) {
            dArray[i] = this.matrix.get(n, this.getIndexFromMap(this.colMaskMap, i));
        }
        return dArray;
    }

    @Override
    public DoubleVector getRowVector(int n) {
        n = this.getIndexFromMap(this.rowMaskMap, n);
        DoubleVector doubleVector = this.matrix.getRowVector(n);
        return new MaskedDoubleVectorView(doubleVector, this.colMaskMap);
    }

    @Override
    public int columns() {
        return this.colMaskMap.length;
    }

    @Override
    public double[][] toDenseArray() {
        double[][] dArray = new double[this.rows()][this.columns()];
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                dArray[i][j] = this.get(i, j);
            }
        }
        return dArray;
    }

    @Override
    public int rows() {
        return this.rowMaskMap.length;
    }

    @Override
    public void set(int n, int n2, double d) {
        n = this.getIndexFromMap(this.rowMaskMap, n);
        n2 = this.getIndexFromMap(this.colMaskMap, n2);
        this.matrix.set(n, n2, d);
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        n = this.getIndexFromMap(this.colMaskMap, n);
        for (int i = 0; i < this.rows(); ++i) {
            this.matrix.set(this.getIndexFromMap(this.rowMaskMap, i), n, dArray[i]);
        }
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        n = this.getIndexFromMap(this.colMaskMap, n);
        for (int i = 0; i < this.rows(); ++i) {
            this.matrix.set(this.getIndexFromMap(this.rowMaskMap, i), n, doubleVector.get(i));
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        n = this.getIndexFromMap(this.rowMaskMap, n);
        for (int i = 0; i < this.columns(); ++i) {
            this.matrix.set(n, this.getIndexFromMap(this.colMaskMap, i), dArray[i]);
        }
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        n = this.getIndexFromMap(this.rowMaskMap, n);
        for (int i = 0; i < this.columns(); ++i) {
            this.matrix.set(n, this.getIndexFromMap(this.colMaskMap, i), doubleVector.get(i));
        }
    }
}

