/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.FileTransformer;
import edu.ucla.sspace.matrix.GlobalTransform;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.matrix.Transform;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.io.File;
import java.io.IOException;

public abstract class BaseTransform
implements Transform {
    @Override
    public File transform(File file, MatrixIO.Format format) throws IOException {
        File file2 = File.createTempFile(file.getName() + ".matrix-transform", ".dat");
        this.transform(file, format, file2);
        return file2;
    }

    @Override
    public void transform(File file, MatrixIO.Format format, File file2) throws IOException {
        GlobalTransform globalTransform = this.getTransform(file, format);
        FileTransformer fileTransformer = MatrixIO.fileTransformer(format);
        fileTransformer.transform(file, file2, globalTransform);
    }

    @Override
    public Matrix transform(Matrix matrix) {
        return this.transform(matrix, matrix);
    }

    @Override
    public Matrix transform(Matrix matrix, Matrix matrix2) {
        if (matrix.rows() != matrix2.rows() || matrix.columns() != matrix2.columns()) {
            throw new IllegalArgumentException("Dimensions of the transformed matrix must match the input matrix");
        }
        GlobalTransform globalTransform = this.getTransform(matrix);
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            for (int i = 0; i < matrix.rows(); ++i) {
                SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(i);
                for (int n : sparseDoubleVector.getNonZeroIndices()) {
                    double d = globalTransform.transform(i, n, sparseDoubleVector.get(n));
                    matrix2.set(i, n, d);
                }
            }
        } else {
            for (int i = 0; i < matrix.rows(); ++i) {
                for (int j = 0; j < matrix.columns(); ++j) {
                    double d = matrix.get(i, j);
                    if (d == 0.0) continue;
                    double d2 = globalTransform.transform(i, j, d);
                    matrix2.set(i, j, d2);
                }
            }
        }
        return matrix2;
    }

    protected abstract GlobalTransform getTransform(Matrix var1);

    protected abstract GlobalTransform getTransform(File var1, MatrixIO.Format var2);
}

