/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.RowComparator;
import edu.ucla.sspace.matrix.SvdlibcSparseBinaryFileRowIterator;
import edu.ucla.sspace.util.BoundedSortedMultiMap;
import edu.ucla.sspace.util.Duple;
import edu.ucla.sspace.util.SortedMultiMap;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.VectorMath;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.logging.Logger;

public class AffinityMatrixCreator {
    private static final Logger LOGGER = Logger.getLogger(AffinityMatrixCreator.class.getName());

    private AffinityMatrixCreator() {
    }

    public static MatrixFile calculate(Matrix matrix, Similarity.SimType simType, EdgeType edgeType, double d, EdgeWeighting edgeWeighting, double d2) {
        try {
            File file = File.createTempFile("affinty-matrix", ".dat");
            PrintWriter printWriter = new PrintWriter(file);
            int n = matrix.rows();
            LOGGER.fine("Calculating the affinity matrix");
            switch (edgeType) {
                case NEAREST_NEIGHBORS: {
                    RowComparator rowComparator = new RowComparator();
                    for (int i = 0; i < n; ++i) {
                        LOGGER.fine("computing affinity for row " + i);
                        SortedMultiMap<Double, Integer> sortedMultiMap = rowComparator.getMostSimilar(matrix, i, (int)d, simType);
                        DoubleVector doubleVector = matrix.getRowVector(i);
                        Iterator iterator = sortedMultiMap.values().iterator();
                        while (iterator.hasNext()) {
                            int n2 = (Integer)iterator.next();
                            double d3 = AffinityMatrixCreator.getWeight(doubleVector, matrix.getRowVector(n2), edgeWeighting, d2);
                            printWriter.println(i + 1 + " " + (n2 + 1) + " " + d3);
                        }
                    }
                    break;
                }
                case MIN_SIMILARITY: {
                    for (int i = 0; i < n; ++i) {
                        LOGGER.fine("computing affinity for row " + i);
                        DoubleVector doubleVector = matrix.getRowVector(i);
                        for (int j = i + 1; j < n; ++j) {
                            DoubleVector doubleVector2 = matrix.getRowVector(j);
                            double d4 = Similarity.getSimilarity(simType, doubleVector, doubleVector2);
                            if (!(d4 > d)) continue;
                            double d5 = AffinityMatrixCreator.getWeight(doubleVector, doubleVector2, edgeWeighting, d2);
                            printWriter.println(i + 1 + " " + (j + 1) + " " + d5);
                            printWriter.println(j + 1 + " " + (i + 1) + " " + d5);
                        }
                    }
                    break;
                }
                default: {
                    assert (false) : "Cannot construct matrix due to unknown edge type: " + (Object)((Object)edgeType);
                    break;
                }
            }
            printWriter.close();
            return new MatrixFile(file, MatrixIO.Format.MATLAB_SPARSE);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public static MatrixFile calculate(MatrixFile matrixFile, Similarity.SimType simType, EdgeType edgeType, double d, EdgeWeighting edgeWeighting, double d2) {
        return AffinityMatrixCreator.calculate(matrixFile, simType, edgeType, d, edgeWeighting, d2, false);
    }

    public static MatrixFile calculate(MatrixFile matrixFile, Similarity.SimType simType, EdgeType edgeType, double d, EdgeWeighting edgeWeighting, double d2, boolean bl) {
        File file = matrixFile.getFile();
        MatrixIO.Format format = matrixFile.getFormat();
        try {
            LOGGER.fine("Converting input matrix to new format for faster calculation of the affinity matrix");
            File file2 = MatrixIO.convertFormat(file, format, MatrixIO.Format.SVDLIBC_SPARSE_BINARY, !bl);
            LOGGER.fine("Calculating the affinity matrix");
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            dataInputStream.close();
            File file3 = File.createTempFile("affinity-matrix", ".dat");
            PrintWriter printWriter = new PrintWriter(file3);
            SparseDoubleVector sparseDoubleVector = null;
            SparseDoubleVector sparseDoubleVector2 = null;
            SvdlibcSparseBinaryFileRowIterator svdlibcSparseBinaryFileRowIterator = new SvdlibcSparseBinaryFileRowIterator(file2);
            for (int i = 0; i < n2; ++i) {
                LOGGER.fine("computing affinity for row " + i);
                int n3 = edgeType.equals((Object)EdgeType.NEAREST_NEIGHBORS) ? (int)d : 1;
                BoundedSortedMultiMap<Double, Duple<Integer, Double>> boundedSortedMultiMap = new BoundedSortedMultiMap<Double, Duple<Integer, Double>>(n3, false);
                block7: for (int j = 0; j < n2; ++j) {
                    if (i == 0 && sparseDoubleVector == null) {
                        sparseDoubleVector = svdlibcSparseBinaryFileRowIterator.next();
                        continue;
                    }
                    Object object = svdlibcSparseBinaryFileRowIterator.next();
                    if (edgeType.equals((Object)EdgeType.MIN_SIMILARITY) && j < i) continue;
                    if (j == i + 1) {
                        sparseDoubleVector2 = object;
                    }
                    double d3 = Similarity.getSimilarity(simType, sparseDoubleVector, object);
                    switch (edgeType) {
                        case NEAREST_NEIGHBORS: {
                            double d4 = AffinityMatrixCreator.getWeight(sparseDoubleVector, (Vector)object, edgeWeighting, d2);
                            boundedSortedMultiMap.put(d3, new Duple<Integer, Double>(j, d4));
                            continue block7;
                        }
                        case MIN_SIMILARITY: {
                            if (!(d3 > d)) continue block7;
                            double d4 = AffinityMatrixCreator.getWeight(sparseDoubleVector, (Vector)object, edgeWeighting, d2);
                            printWriter.println(i + 1 + " " + (j + 1) + " " + d4);
                            printWriter.println(j + 1 + " " + (i + 1) + " " + d4);
                            continue block7;
                        }
                        default: {
                            assert (false) : "unhandled edge type: " + (Object)((Object)edgeType);
                            continue block7;
                        }
                    }
                }
                sparseDoubleVector = sparseDoubleVector2;
                if (edgeType.equals((Object)EdgeType.NEAREST_NEIGHBORS)) {
                    for (Object object : boundedSortedMultiMap.values()) {
                        printWriter.println(i + 1 + " " + ((Integer)((Duple)object).x + 1) + " " + ((Duple)object).y);
                    }
                }
                svdlibcSparseBinaryFileRowIterator.reset();
            }
            printWriter.close();
            return new MatrixFile(file3, MatrixIO.Format.MATLAB_SPARSE);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private static double gaussianKernel(Vector vector, Vector vector2, double d) {
        double d2 = Similarity.euclideanDistance(vector, vector2);
        return Math.pow(Math.E, -(d2 / d));
    }

    private static double polynomialKernel(Vector vector, Vector vector2, double d) {
        double d2 = VectorMath.dotProduct(vector, vector2);
        return Math.pow(d2 + 1.0, d);
    }

    private static double getWeight(Vector vector, Vector vector2, EdgeWeighting edgeWeighting, double d) {
        switch (edgeWeighting) {
            case BINARY: {
                return 1.0;
            }
            case GAUSSIAN_KERNEL: {
                return AffinityMatrixCreator.gaussianKernel(vector, vector2, d);
            }
            case POLYNOMIAL_KERNEL: {
                return AffinityMatrixCreator.polynomialKernel(vector, vector2, d);
            }
            case DOT_PRODUCT: {
                return VectorMath.dotProduct(vector, vector2);
            }
            case COSINE_SIMILARITY: {
                return Similarity.cosineSimilarity(vector, vector2);
            }
        }
        assert (false) : "unhandled edge weighting type: " + (Object)((Object)edgeWeighting);
        throw new IllegalArgumentException("unhandled edge weighting type: " + (Object)((Object)edgeWeighting));
    }

    public static enum EdgeWeighting {
        BINARY,
        GAUSSIAN_KERNEL,
        POLYNOMIAL_KERNEL,
        DOT_PRODUCT,
        COSINE_SIMILARITY;

    }

    public static enum EdgeType {
        NEAREST_NEIGHBORS,
        MIN_SIMILARITY;

    }
}

