/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyExtractorManager;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.UniversalPathAcceptor;
import edu.ucla.sspace.mains.DependencyGenericMain;
import edu.ucla.sspace.svs.PointWiseCombinor;
import edu.ucla.sspace.svs.StructuredVectorSpace;
import edu.ucla.sspace.svs.VectorCombinor;
import edu.ucla.sspace.util.ReflectionUtil;
import java.util.Properties;

public class StructuredVectorSpaceMain
extends DependencyGenericMain {
    private StructuredVectorSpaceMain() {
    }

    @Override
    public void addExtraOptions(ArgOptions argOptions) {
        super.addExtraOptions(argOptions);
        argOptions.addOption('a', "pathAcceptor", "The DependencyPathAcceptor to use", true, "CLASSNAME", "Algorithm Options");
        argOptions.addOption('c', "vectorCombinor", "The VectorCombinor to use", true, "CLASSNAME", "Algorithm Options");
    }

    public static void main(String[] stringArray) throws Exception {
        StructuredVectorSpaceMain structuredVectorSpaceMain = new StructuredVectorSpaceMain();
        structuredVectorSpaceMain.run(stringArray);
    }

    @Override
    protected SemanticSpace getSpace() {
        this.setupDependencyExtractor();
        DependencyPathAcceptor dependencyPathAcceptor = this.argOptions.hasOption("pathAcceptor") ? (DependencyPathAcceptor)ReflectionUtil.getObjectInstance(this.argOptions.getStringOption("pathAcceptor")) : new UniversalPathAcceptor();
        VectorCombinor vectorCombinor = this.argOptions.hasOption("pathAcceptor") ? (VectorCombinor)ReflectionUtil.getObjectInstance(this.argOptions.getStringOption("vectorCombinor")) : new PointWiseCombinor();
        DependencyExtractor dependencyExtractor = DependencyExtractorManager.getDefaultExtractor();
        return new StructuredVectorSpace(dependencyExtractor, dependencyPathAcceptor, vectorCombinor);
    }

    @Override
    protected Properties setupProperties() {
        return System.getProperties();
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SERIALIZE;
    }
}

