/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.mains.GenericMain;
import edu.ucla.sspace.rri.ReflectiveRandomIndexing;
import java.util.Properties;
import java.util.logging.Logger;

public class ReflectiveRandomIndexingMain
extends GenericMain {
    private static final Logger LOGGER = Logger.getLogger(ReflectiveRandomIndexingMain.class.getName());
    private Properties props;
    private ReflectiveRandomIndexing ri = null;

    private ReflectiveRandomIndexingMain() {
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('l', "vectorLength", "length of semantic vectors", true, "INT", "Algorithm Options");
        argOptions.addOption('n', "permutationFunction", "permutation function to use.  This should be genric for TernaryVectors", true, "CLASSNAME", "Advanced Algorithm Options");
        argOptions.addOption('p', "usePermutations", "whether to permute index vectors based on word order", true, "BOOL", "Algorithm Options");
        argOptions.addOption('r', "useSparseSemantics", "use a sparse encoding of semantics to save memory", true, "BOOL", "Algorithm Options");
        argOptions.addOption('s', "windowSize", "how many words to consider in each direction", true, "INT", "Algorithm Options");
        argOptions.addOption('S', "saveVectors", "save word-to-IndexVector mapping after processing", true, "FILE", "Algorithm Options");
        argOptions.addOption('L', "loadVectors", "load word-to-IndexVector mapping before processing", true, "FILE", "Algorithm Options");
    }

    public static void main(String[] stringArray) {
        try {
            ReflectiveRandomIndexingMain reflectiveRandomIndexingMain = new ReflectiveRandomIndexingMain();
            reflectiveRandomIndexingMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected Properties setupProperties() {
        this.props = System.getProperties();
        if (this.argOptions.hasOption("vectorLength")) {
            this.props.setProperty("edu.ucla.sspace.ri.ReflectiveRandomIndexing.vectorLength", this.argOptions.getStringOption("vectorLength"));
        }
        if (this.argOptions.hasOption("useSparseSemantics")) {
            this.props.setProperty("edu.ucla.sspace.ri.ReflectiveRandomIndexing.sparseSemantics", this.argOptions.getStringOption("useSparseSemantics"));
        }
        return this.props;
    }

    @Override
    protected SemanticSpace getSpace() {
        this.ri = new ReflectiveRandomIndexing(this.props);
        return this.ri;
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }
}

