/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.mains.GenericMain;
import edu.ucla.sspace.nonlinear.LocalityPreservingCooccurrenceSpace;
import java.util.Properties;

public class LpcsMain
extends GenericMain {
    private LpcsMain() {
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('n', "dimensions", "the number of dimensions in the semantic space", true, "INT", "Algorithm Options");
        argOptions.addOption('e', "edgeType", "the method to used for adding edge to the affinity matrix", true, "EdgeType", "Algorithm Options");
        argOptions.addOption('E', "edgeTypeParam", "a parameter that the EdgeType selection process may use", true, "DOUBLE", "Algorithm Options");
        argOptions.addOption('W', "edgeWeighting", "the method for weighting edges in the affinity matrix", true, "EdgeWeighting", "Algorithm Options");
        argOptions.addOption('G', "edgeWeightingParam", "a parameter for the edge weighting process", true, "DOUBLE", "Algorithm Options");
        argOptions.addOption('s', "windowSize", "The number of words to inspect to the left and right of a focus word (default: 5)", true, "INT", "Algorithm Options");
    }

    public static void main(String[] stringArray) {
        LpcsMain lpcsMain = new LpcsMain();
        try {
            lpcsMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected SemanticSpace getSpace() {
        return new LocalityPreservingCooccurrenceSpace();
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.BINARY;
    }

    @Override
    protected Properties setupProperties() {
        Properties properties = System.getProperties();
        if (this.argOptions.hasOption("windowSize")) {
            properties.setProperty("edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.windowSize", this.argOptions.getStringOption("windowSize"));
        }
        if (this.argOptions.hasOption("dimensions")) {
            properties.setProperty("edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.dimensions", this.argOptions.getStringOption("dimensions"));
        }
        if (this.argOptions.hasOption("edgeType")) {
            properties.setProperty("edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeType", this.argOptions.getStringOption("edgeType"));
        }
        if (this.argOptions.hasOption("edgeTypeParam")) {
            properties.setProperty("edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeTypeParam", this.argOptions.getStringOption("edgeTypeParam"));
        }
        if (this.argOptions.hasOption("edgeWeighting")) {
            properties.setProperty("edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeWeighting", this.argOptions.getStringOption("edgeWeighting"));
        }
        if (this.argOptions.hasOption("edgeWeightingParam")) {
            properties.setProperty("edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeWeightingParam", this.argOptions.getStringOption("edgeWeightingParam"));
        }
        return properties;
    }

    @Override
    protected String getAlgorithmSpecifics() {
        return "The --edgeType option specifies the method by which words are connected in\nthe affinity matrix.  Two options are provided: NEAREST_NEIGHBORS and\nMIN_SIMILARITY.  Each takes a parameter specified by the --edgeTypeParam\noption.  For NEAREST_NEIGHBORS, the parameter specifies how many words will\nbe counted as edges in the affinity matrix.  For MIN_SIMILARITY, the parameter\nspecifies the minimum similarity for two words to have an edge.\n\nThe --edgeWeighting option specifies how edges in the affinity matrix should\nbe weighted.  Valid options are: BINARY, GAUSSIAN_KERNEL, POLYNOMIAL_KERNEL,\nDOT_PRODUCT, COSINE_SIMILARITY.  The Gaussian and polynomial kernels take an\noptional parameter specified by --edgeWeightingParam that weights the kernel\nfunction.  The other options ignore the value of the parameter.\n\nThe default behavior is the use NEAREST_NEIGHBORS with a value of 20 and\nCOSINE_SIMILARITY edge weighting.";
    }
}

