/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.lsa.LatentSemanticAnalysis;
import edu.ucla.sspace.mains.GenericMain;
import java.io.IOError;
import java.io.IOException;
import java.util.Properties;

public class LSAMain
extends GenericMain {
    private LSAMain() {
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('n', "dimensions", "the number of dimensions in the semantic space", true, "INT", "Algorithm Options");
        argOptions.addOption('p', "preprocess", "a MatrixTransform class to use for preprocessing", true, "CLASSNAME", "Algorithm Options");
        argOptions.addOption('S', "svdAlgorithm", "a specific SVD algorithm to use", true, "SVD.Algorithm", "Advanced Algorithm Options");
    }

    public static void main(String[] stringArray) {
        LSAMain lSAMain = new LSAMain();
        try {
            lSAMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected SemanticSpace getSpace() {
        try {
            return new LatentSemanticAnalysis();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.BINARY;
    }

    @Override
    protected Properties setupProperties() {
        Properties properties = System.getProperties();
        if (this.argOptions.hasOption("dimensions")) {
            properties.setProperty("edu.ucla.sspace.lsa.LatentSemanticAnalysis.dimensions", this.argOptions.getStringOption("dimensions"));
        }
        if (this.argOptions.hasOption("preprocess")) {
            properties.setProperty("edu.ucla.sspace.lsa.LatentSemanticAnalysis.transform", this.argOptions.getStringOption("preprocess"));
        }
        if (this.argOptions.hasOption("svdAlgorithm")) {
            properties.setProperty("edu.ucla.sspace.lsa.LatentSemanticAnalysis.svd.algorithm", this.argOptions.getStringOption("svdAlgorithm"));
        }
        return properties;
    }

    @Override
    protected String getAlgorithmSpecifics() {
        return "The --svdAlgorithm provides a way to manually specify which algorithm should\nbe used internally.  This option should not be used normally, as LSA will\nselect the fastest algorithm available.  However, in the event that it\nis needed, valid options are: SVDLIBC, SVDLIBJ, MATLAB, OCTAVE, JAMA and COLT\n";
    }
}

